/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.crafting;

import javax.annotation.Nonnull;
import mcjty.lib.crafting.AbstractRecipeAdaptor;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.setup.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;

public class CopyComponentsRecipe
extends AbstractRecipeAdaptor {
    public CopyComponentsRecipe(ShapedRecipe recipe) {
        super(recipe);
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        ItemStack result = this.getRecipe().assemble(inv, access);
        Object nbt = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            IComponentsToPreserve inbt = null;
            Item item = stack.getItem();
            if (item instanceof IComponentsToPreserve) {
                IComponentsToPreserve ingredient;
                inbt = ingredient = (IComponentsToPreserve)item;
            } else {
                BlockItem blockItem;
                Block block;
                item = stack.getItem();
                if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IComponentsToPreserve) {
                    IComponentsToPreserve ingredient;
                    inbt = ingredient = (IComponentsToPreserve)block;
                }
            }
            if (inbt == null) continue;
            for (DataComponentType<?> type : inbt.getComponentsToPreserve()) {
                Object o = stack.get(type);
                if (o == null) continue;
                result.set(type, o);
            }
        }
        return result;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.getRecipe().getResultItem(provider);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return Registration.COPYNBT_SERIALIZER.get();
    }
}

