/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.mobs.util.BasicBossData;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.StepFunction;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class InvaderProvider
extends DynamicRegistryProvider<Invader> {
    public static final int DEFAULT_WEIGHT = 100;
    public static final float DEFAULT_QUALITY = 0.1f;

    public InvaderProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)InvaderRegistry.INSTANCE);
    }

    public String getName() {
        return "Apothic Invaders";
    }

    public void generate() {
        HolderLookup.Provider registries = (HolderLookup.Provider)this.lookupProvider.join();
        HolderLookup.RegistryLookup biomes = (HolderLookup.RegistryLookup)registries.lookup(Registries.BIOME).get();
        LootRarity rare = InvaderProvider.rarity("rare");
        LootRarity epic = InvaderProvider.rarity("epic");
        LootRarity mythic = InvaderProvider.rarity("mythic");
        this.addBoss("overworld/zombie", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.ZOMBIE).size(0.75, 2.45).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/husk", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.HUSK).size(0.75, 2.45).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 50, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/husk_in_dry", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.HUSK).size(0.75, 2.45).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(120, 0.1f)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup<Biome>)biomes, (TagKey<Biome>)Tags.Biomes.IS_DRY_OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/enderman", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.ENDERMAN).size(0.75, 3.7).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.ASCENT, 100, 1.5f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)));
        this.addBoss("overworld/vindicator", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.VINDICATOR).size(0.75, 2.45).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.ASCENT, 100, 1.5f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)));
        this.addBoss("overworld/wolf", b -> b.entity((EntityType<? extends Mob>)EntityType.WOLF).size(1.5, 2.5).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 100, 1.5f)).constraints(x -> x.dimensions(Level.OVERWORLD).biomes((HolderLookup.RegistryLookup<Biome>)biomes, (TagKey<Biome>)Tags.Biomes.IS_SNOWY)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS).nbt(t -> t.putInt("AngerTime", 99999999))).stats(rare, c -> c.enchantChance(0.35f).enchLevels(23, 15).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 50.0f, 70.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.25f, 0.45f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.35f, 0.55f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.4f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, StepFunction.constant((float)1.25f))).stats(epic, c -> c.enchantChance(0.6f).enchLevels(35, 25).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 60.0f, 100.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.3f, 0.5f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.4f, 0.75f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.5f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)6.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)12.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, StepFunction.constant((float)1.25f))).stats(mythic, c -> c.enchantChance(0.75f).enchLevels(35, 25).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 90.0f, 140.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.35f, 0.65f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.7f, 1.1f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.8f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)12.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, StepFunction.constant((float)1.25f))));
        this.addBoss("overworld/skeleton", b -> InvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.SKELETON).size(0.75, 2.45).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/stray", b -> InvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.STRAY).size(0.75, 2.45).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 50, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/bogged", b -> InvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.BOGGED).size(0.75, 2.45).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 50, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/stray_in_cold", b -> InvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.STRAY).size(0.75, 2.45).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(120, 0.1f)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup<Biome>)biomes, (TagKey<Biome>)Tags.Biomes.IS_COLD_OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/bogged_in_wet", b -> InvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.BOGGED).size(0.75, 2.45).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(120, 0.1f)).constraints(Constraints.forBiomes((HolderLookup.RegistryLookup<Biome>)biomes, (TagKey<Biome>)Tags.Biomes.IS_WET_OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("overworld/breeze", b -> b.entity((EntityType<? extends Mob>)EntityType.BREEZE).size(1.2, 3.6).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.SUMMIT, 100, 1.5f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)).stats(mythic, c -> c.enchantChance(1.0f).enchLevels(100, 80).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).effect(1.0f, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 90.0f, 140.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.35f, 0.65f).modifier((Holder<Attribute>)ALObjects.Attributes.COLD_DAMAGE, AttributeModifier.Operation.ADD_VALUE, 30.0f, 40.0f).modifier((Holder<Attribute>)ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 2.25f, 4.15f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.8f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)12.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, StepFunction.constant((float)1.0f))));
        this.addBoss("the_nether/zombified_piglin", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.ZOMBIFIED_PIGLIN).size(0.75, 2.45).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.NETHER)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("the_nether/piglin", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.PIGLIN).size(0.75, 2.45).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.NETHER)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS).nbt(t -> t.putInt("AngerTime", 99999999))));
        this.addBoss("the_nether/piglin_brute", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.PIGLIN_BRUTE).size(0.75, 2.45).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.ASCENT, 100, 1.5f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.NETHER)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)));
        this.addBoss("the_nether/zoglin", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.ZOGLIN).size(2.0, 2.0).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 100, 2.0f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.NETHER)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("the_nether/wither_skeleton", b -> b.entity((EntityType<? extends Mob>)EntityType.WITHER_SKELETON).size(0.75, 3.7).basicData(c -> InvaderProvider.rangedGear(InvaderProvider.meleeGear(c)).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.ASCENT, 100, 1.5f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.NETHER)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)).stats(epic, c -> c.enchantChance(0.75f).enchLevels(45, 30).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 60.0f, 100.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.3f, 0.5f).modifier((Holder<Attribute>)ALObjects.Attributes.FIRE_DAMAGE, AttributeModifier.Operation.ADD_VALUE, 7.0f, 12.0f).modifier((Holder<Attribute>)ALObjects.Attributes.ARROW_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.45f, 0.65f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.5f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)6.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)12.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)).stats(mythic, c -> c.enchantChance(0.95f).enchLevels(60, 40).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 90.0f, 140.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.35f, 0.65f).modifier((Holder<Attribute>)ALObjects.Attributes.FIRE_DAMAGE, AttributeModifier.Operation.ADD_VALUE, 12.0f, 20.0f).modifier((Holder<Attribute>)ALObjects.Attributes.ARROW_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.75f, 1.2f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.8f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)12.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)));
        this.addBoss("the_nether/blaze", b -> b.entity((EntityType<? extends Mob>)EntityType.BLAZE).size(1.2, 3.6).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.SUMMIT, 100, 1.5f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.NETHER)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)).stats(mythic, c -> c.enchantChance(1.0f).enchLevels(100, 80).effect(1.0f, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 90.0f, 140.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.35f, 0.65f).modifier((Holder<Attribute>)ALObjects.Attributes.FIRE_DAMAGE, AttributeModifier.Operation.ADD_VALUE, 30.0f, 40.0f).modifier((Holder<Attribute>)ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 2.75f, 5.5f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.8f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)12.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, StepFunction.constant((float)1.0f))));
        this.addBoss("the_end/enderman", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.ENDERMAN).size(0.75, 3.7).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.END)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("the_end/endermite", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.ENDERMITE).size(0.5, 0.5).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(5, 2.0f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.END)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("the_end/shulker", b -> InvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.SHULKER).size(1.25, 1.25).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forAllTiers(20, 2.0f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.END)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS)));
        this.addBoss("the_end/phantom", b -> InvaderProvider.basicMeleeStats(b).entity((EntityType<? extends Mob>)EntityType.PHANTOM).size(1.2, 0.75).basicData(c -> InvaderProvider.meleeGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.ASCENT, 50, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.END)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)));
        this.addBoss("the_end/evoker", b -> InvaderProvider.basicRangedStats(b).entity((EntityType<? extends Mob>)EntityType.EVOKER).size(0.75, 2.45).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"use_name_generation")).weights(TieredWeights.forTiersAbove(WorldTier.SUMMIT, 100, 1.5f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.END)).bonusLoot(Apoth.LootTables.BONUS_BOSS_DROPS, Apoth.LootTables.BONUS_RARE_BOSS_DROPS)));
    }

    protected static Invader.Builder basicMeleeStats(Invader.Builder builder) {
        LootRarity uncommon = InvaderProvider.rarity("uncommon");
        LootRarity rare = InvaderProvider.rarity("rare");
        LootRarity epic = InvaderProvider.rarity("epic");
        LootRarity mythic = InvaderProvider.rarity("mythic");
        return builder.stats(uncommon, c -> c.enchantChance(0.25f).enchLevels(20, 12).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 20.0f, 60.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.15f, 0.2f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.2f, 0.4f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.3f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)).stats(rare, c -> c.enchantChance(0.35f).enchLevels(23, 15).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 40.0f, 90.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.15f, 0.25f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.25f, 0.5f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.4f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)).stats(epic, c -> c.enchantChance(0.6f).enchLevels(35, 25).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 80.0f, 150.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.25f, 0.4f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.3f, 0.65f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.5f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)4.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)10.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)).stats(mythic, c -> c.enchantChance(0.75f).enchLevels(35, 25).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 110.0f, 180.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.3f, 0.65f).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.7f, 1.05f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.8f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)10.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    protected static Invader.Builder basicRangedStats(Invader.Builder builder) {
        LootRarity uncommon = InvaderProvider.rarity("uncommon");
        LootRarity rare = InvaderProvider.rarity("rare");
        LootRarity epic = InvaderProvider.rarity("epic");
        LootRarity mythic = InvaderProvider.rarity("mythic");
        return builder.stats(uncommon, c -> c.enchantChance(0.25f).enchLevels(20, 12).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 20.0f, 50.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.05f, 0.1f).modifier((Holder<Attribute>)ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.2f, 0.4f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.25f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)).stats(rare, c -> c.enchantChance(0.35f).enchLevels(23, 15).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 45.0f, 70.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.15f, 0.25f).modifier((Holder<Attribute>)ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.3f, 0.55f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.4f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)).stats(epic, c -> c.enchantChance(0.6f).enchLevels(35, 25).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 95.0f, 120.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.25f, 0.4f).modifier((Holder<Attribute>)ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.45f, 0.65f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.5f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)4.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)10.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f)).stats(mythic, c -> c.enchantChance(0.75f).enchLevels(35, 25).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 125.0f, 150.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.3f, 0.65f).modifier((Holder<Attribute>)ALObjects.Attributes.PROJECTILE_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.75f, 1.2f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.8f)).modifier((Holder<Attribute>)Attributes.ARMOR, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)10.0f)).modifier((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)20.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, -0.15f, 0.25f));
    }

    public static BasicBossData.Builder meleeGear(BasicBossData.Builder builder) {
        builder.gearSets(WorldTier.HAVEN, "#haven_melee");
        builder.gearSets(WorldTier.FRONTIER, "#frontier_melee");
        builder.gearSets(WorldTier.ASCENT, "#ascent_melee");
        builder.gearSets(WorldTier.SUMMIT, "#summit_melee");
        builder.gearSets(WorldTier.PINNACLE, "#pinnacle_melee");
        return builder;
    }

    public static BasicBossData.Builder rangedGear(BasicBossData.Builder builder) {
        builder.gearSets(WorldTier.HAVEN, "#haven_ranged");
        builder.gearSets(WorldTier.FRONTIER, "#frontier_ranged");
        builder.gearSets(WorldTier.ASCENT, "#ascent_ranged");
        builder.gearSets(WorldTier.SUMMIT, "#summit_ranged");
        builder.gearSets(WorldTier.PINNACLE, "#pinnacle_ranged");
        return builder;
    }

    protected void addBoss(String name, UnaryOperator<Invader.Builder> builder) {
        this.add(Apotheosis.loc(name), ((Invader.Builder)builder.apply(Invader.builder())).build());
    }

    protected static LootRarity rarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(Apotheosis.loc(path))));
    }
}

