/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class GatewaysCompat {
    public static void register() {
        WaveEntity.CODEC.register(Apotheosis.loc("invader"), InvaderWaveEntity.CODEC);
    }

    public record InvaderWaveEntity(DynamicHolder<Invader> invader, String desc) implements WaveEntity
    {
        public static Codec<InvaderWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)InvaderRegistry.INSTANCE.holderCodec().optionalFieldOf("invader", (Object)InvaderRegistry.INSTANCE.emptyHolder()).forGetter(InvaderWaveEntity::invader), (App)Codec.STRING.optionalFieldOf("desc").forGetter(b -> Optional.of(b.desc))).apply((Applicative)inst, InvaderWaveEntity::new));

        public InvaderWaveEntity(DynamicHolder<Invader> invader, Optional<String> desc) {
            this(invader, desc.orElse(InvaderWaveEntity.resolveInvaderDesc(invader)));
        }

        public LivingEntity createEntity(ServerLevel level, GatewayEntity gate) {
            GenContext ctx = GenContext.forPlayer(gate.summonerOrClosest());
            Invader realBoss = this.resolveInvader(ctx);
            if (realBoss == null) {
                if (this.usingRandomInvader()) {
                    Apotheosis.LOGGER.error("Failed to resolve a random invader when generating a InvaderWaveEntity!");
                } else {
                    String type = this.invader.getId().toString();
                    Apotheosis.LOGGER.error("Failed to resolve the invader '{}' when generating a InvaderWaveEntity!", (Object)type);
                }
                return null;
            }
            return realBoss.createBoss((ServerLevelAccessor)level, BlockPos.ZERO, ctx);
        }

        public MutableComponent getDescription() {
            return Component.translatable((String)"misc.apotheosis.invader", (Object[])new Object[]{Component.translatable((String)this.desc)});
        }

        public boolean shouldFinalizeSpawn() {
            return false;
        }

        public Codec<? extends WaveEntity> getCodec() {
            return CODEC;
        }

        public int getCount() {
            return 1;
        }

        protected boolean usingRandomInvader() {
            return this.invader.equals((Object)InvaderRegistry.INSTANCE.emptyHolder());
        }

        @Nullable
        protected Invader resolveInvader(GenContext ctx) {
            if (this.usingRandomInvader()) {
                return InvaderRegistry.INSTANCE.getRandomItem(ctx);
            }
            return this.invader().getOptional().orElse(null);
        }

        public static String resolveInvaderDesc(DynamicHolder<Invader> invader) {
            return invader.isBound() ? ((Invader)invader.get()).entity().getDescriptionId() : "misc.apotheosis.random";
        }
    }
}

