/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class RarityCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_RARITY = (ctx, builder) -> SharedSuggestionProvider.suggest(RarityRegistry.INSTANCE.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"set_rarity").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"rarity", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_RARITY).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            LootRarity rarity = (LootRarity)RarityRegistry.INSTANCE.getValue(ResourceLocationArgument.getId((CommandContext)c, (String)"rarity"));
            ItemStack stack = p.getMainHandItem();
            AffixHelper.setRarity(stack, rarity);
            return 0;
        })));
    }
}

