/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.AttributeProvidingAffix;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apothic_attributes.modifiers.StackAttributeModifiersEvent;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class MultiAttrAffix
extends Affix
implements AttributeProvidingAffix {
    public static final Codec<MultiAttrAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(MultiAttrAffix.affixDef(), (App)ModifierInst.CODEC.listOf().fieldOf("modifiers").forGetter(a -> a.modifiers), (App)Codec.STRING.fieldOf("desc").forGetter(a -> a.desc), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories)).apply((Applicative)inst, MultiAttrAffix::new));
    protected final List<ModifierInst> modifiers;
    protected final String desc;
    protected final Set<LootCategory> categories;
    protected final transient Set<LootRarity> rarities;

    public MultiAttrAffix(AffixDefinition def, List<ModifierInst> modifiers, String desc, Set<LootCategory> categories) {
        super(def);
        this.modifiers = modifiers;
        this.desc = desc;
        this.categories = categories;
        HashSet<LootRarity> rarities = new HashSet<LootRarity>();
        for (int i = 0; i < modifiers.size(); ++i) {
            ModifierInst inst = modifiers.get(i);
            if (rarities.isEmpty()) {
                rarities.addAll(inst.values.keySet());
            }
            if (rarities.equals(inst.values.keySet())) continue;
            throw new IllegalArgumentException("Disjoint rarity sets at modifier index " + i + "! Specified set: " + String.valueOf(rarities) + " but found: " + String.valueOf(inst.values.keySet()));
        }
        this.rarities = rarities;
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.empty();
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        Object[] values = new Object[this.modifiers.size()];
        for (int i = 0; i < this.modifiers.size(); ++i) {
            ModifierInst modif = this.modifiers.get(i);
            Attribute attr = (Attribute)modif.attr().value();
            MutableComponent comp = attr.toComponent(modif.build(inst, i), ctx.flag());
            StepFunction valueFactory = modif.values.get(inst.getRarity());
            if (valueFactory.get(0.0f) != valueFactory.get(1.0f)) {
                MutableComponent minComp = attr.toValueComponent(modif.op, (double)valueFactory.get(0.0f), ctx.flag());
                MutableComponent maxComp = attr.toValueComponent(modif.op, (double)valueFactory.get(1.0f), ctx.flag());
                comp.append((Component)MultiAttrAffix.valueBounds((Component)minComp, (Component)maxComp));
            }
            values[i] = comp;
        }
        return Component.translatable((String)this.desc, (Object[])values).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public void addModifiers(AffixInstance inst, StackAttributeModifiersEvent event) {
        LootCategory cat = inst.category();
        if (cat.isNone()) {
            Apotheosis.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.id(), (Object)inst.stack().getHoverName().getString());
            return;
        }
        for (int i = 0; i < this.modifiers.size(); ++i) {
            ModifierInst modif = this.modifiers.get(i);
            if (modif.attr == null) {
                Apotheosis.LOGGER.debug("The affix {} has attempted to apply a null attribute modifier to {}!", (Object)this.id(), (Object)inst.stack().getHoverName().getString());
                return;
            }
            event.addModifier(modif.attr(), modif.build(inst, i), cat.getSlots());
        }
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat.isNone()) {
            return false;
        }
        return (this.categories.isEmpty() || this.categories.contains(cat)) && this.rarities.contains(rarity);
    }

    @Override
    public void gatherModifierTooltips(AffixInstance inst, AttributeTooltipContext ctx, Consumer<Component> list) {
        for (int i = 0; i < this.modifiers.size(); ++i) {
            ModifierInst modif = this.modifiers.get(i);
            Attribute attr = (Attribute)modif.attr.value();
            list.accept((Component)attr.toComponent(modif.build(inst, i), ctx.flag()));
        }
    }

    @Override
    public void skipModifierIds(AffixInstance inst, AttributeTooltipContext ctx, Consumer<ResourceLocation> skip) {
        if (ctx.player() != null && WorldTier.isTutorialActive(ctx.player())) {
            for (int i = 0; i < this.modifiers.size(); ++i) {
                skip.accept(inst.makeUniqueId("" + i));
            }
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public record ModifierInst(Holder<Attribute> attr, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values) {
        public static Codec<ModifierInst> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(ModifierInst::attr), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(ModifierInst::op), (App)LootRarity.mapCodec(StepFunction.CODEC).fieldOf("values").forGetter(ModifierInst::values)).apply((Applicative)inst, ModifierInst::new));

        public AttributeModifier build(AffixInstance inst, int idx) {
            return new AttributeModifier(inst.makeUniqueId("" + idx), (double)this.values.get(inst.getRarity()).get(inst.level()), this.op);
        }

        public static class Builder {
            private Holder<Attribute> attr;
            private AttributeModifier.Operation op;
            protected final Map<LootRarity, StepFunction> values = new HashMap<LootRarity, StepFunction>();
            protected float step = 0.01f;

            public Builder attr(Holder<Attribute> attr) {
                this.attr = attr;
                return this;
            }

            public Builder op(AttributeModifier.Operation op) {
                this.op = op;
                return this;
            }

            public Builder step(float step) {
                this.step = step;
                return this;
            }

            public Builder value(LootRarity rarity, float min, float max) {
                return this.value(rarity, StepFunction.fromBounds((float)min, (float)max, (float)this.step));
            }

            public Builder value(LootRarity rarity, float value) {
                return this.value(rarity, StepFunction.constant((float)value));
            }

            public Builder value(LootRarity rarity, StepFunction function) {
                this.values.put(rarity, function);
                return this;
            }

            public ModifierInst build() {
                return new ModifierInst(this.attr, this.op, this.values);
            }
        }
    }

    public static class Builder
    extends AffixBuilder<Builder> {
        protected final Set<LootCategory> categories = new HashSet<LootCategory>();
        protected final List<ModifierInst> modifiers = new ArrayList<ModifierInst>();
        protected String desc;

        public Builder modifier(UnaryOperator<ModifierInst.Builder> config) {
            this.modifiers.add(((ModifierInst.Builder)config.apply(new ModifierInst.Builder())).build());
            return this;
        }

        public Builder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder categories(LootCategory ... cats) {
            for (LootCategory cat : cats) {
                this.categories.add(cat);
            }
            return this;
        }

        public MultiAttrAffix build() {
            Preconditions.checkArgument((!this.modifiers.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((this.desc != null ? 1 : 0) != 0);
            return new MultiAttrAffix(this.definition, this.modifiers, this.desc, this.categories);
        }
    }
}

