/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apothic_attributes.util.AttributesUtil;
import dev.shadowsoffire.placebo.util.StepFunction;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class DamageReductionAffix
extends Affix {
    public static final Codec<DamageReductionAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(DamageReductionAffix.affixDef(), (App)DamageType.CODEC.fieldOf("damage_type").forGetter(a -> a.type), (App)LootRarity.mapCodec(StepFunction.CODEC).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("categories").forGetter(a -> a.categories)).apply((Applicative)inst, DamageReductionAffix::new));
    protected final DamageType type;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> categories;

    public DamageReductionAffix(AffixDefinition def, DamageType type, Map<LootRarity, StepFunction> values, Set<LootCategory> categories) {
        super(def);
        this.type = type;
        this.values = values;
        this.categories = categories;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return !cat.isNone() && (this.categories.isEmpty() || this.categories.contains(cat)) && this.values.containsKey(rarity);
    }

    @Override
    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)"affix.apotheosis:damage_reduction.desc", (Object[])new Object[]{Component.translatable((String)("misc.apotheosis." + this.type.id)), DamageReductionAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), inst.level()))});
    }

    @Override
    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        MutableComponent comp = this.getDescription(inst, ctx);
        MutableComponent minComp = Component.translatable((String)"%s%%", (Object[])new Object[]{DamageReductionAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), 0.0f))});
        MutableComponent maxComp = Component.translatable((String)"%s%%", (Object[])new Object[]{DamageReductionAffix.fmt(100.0f * this.getTrueLevel(inst.getRarity(), 1.0f))});
        return comp.append((Component)DamageReductionAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    @Override
    public float onHurt(AffixInstance inst, DamageSource src, LivingEntity ent, float amount) {
        if (!src.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !src.is(DamageTypeTags.BYPASSES_ENCHANTMENTS) && this.type.test(src)) {
            return amount * (1.0f - this.getTrueLevel(inst.getRarity(), inst.level()));
        }
        return super.onHurt(inst, src, ent, amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static enum DamageType implements Predicate<DamageSource>,
    StringRepresentable
    {
        PHYSICAL("physical", AttributesUtil::isPhysicalDamage),
        MAGIC("magic", d -> d.is(Tags.DamageTypes.IS_MAGIC)),
        FIRE("fire", d -> d.is(DamageTypeTags.IS_FIRE)),
        FALL("fall", d -> d.is(DamageTypeTags.IS_FALL)),
        EXPLOSION("explosion", d -> d.is(DamageTypeTags.IS_EXPLOSION)),
        PROJECTILE("projectile", d -> d.is(DamageTypeTags.IS_PROJECTILE)),
        LIGHTNING("lightning", d -> d.is(DamageTypeTags.IS_LIGHTNING));

        public static final IntFunction<DamageType> BY_ID;
        public static final Codec<DamageType> CODEC;
        public static final StreamCodec<ByteBuf, DamageType> STREAM_CODEC;
        private final String id;
        private final Predicate<DamageSource> predicate;

        private DamageType(String id, Predicate<DamageSource> predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        @Override
        public boolean test(DamageSource t) {
            return this.predicate.test(t);
        }

        public String getSerializedName() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DamageType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
            CODEC = StringRepresentable.fromValues(DamageType::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static class Builder
    extends AffixBuilder.ValuedAffixBuilder<Builder> {
        protected final DamageType type;
        protected final Set<LootCategory> categories = new LinkedHashSet<LootCategory>();

        public Builder(DamageType type) {
            this.type = type;
        }

        public Builder categories(LootCategory ... cats) {
            for (LootCategory cat : cats) {
                this.categories.add(cat);
            }
            return this;
        }

        public DamageReductionAffix build() {
            Preconditions.checkArgument((!this.values.isEmpty() ? 1 : 0) != 0);
            return new DamageReductionAffix(this.definition, this.type, this.values, this.categories);
        }
    }
}

