/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.augmenting;

import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.ItemAffixes;
import dev.shadowsoffire.apotheosis.affix.augmenting.AugmentingTableTile;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.net.RerollResultPayload;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class AugmentingMenu
extends BlockEntityMenu<AugmentingTableTile> {
    public static final int UPGRADE = 0;
    public static final int REROLL = 1;
    protected final Player player;
    protected InternalItemHandler itemInv = new InternalItemHandler(1);

    public AugmentingMenu(int id, Inventory inv, BlockPos pos) {
        super(Apoth.Menus.AUGMENTING, id, inv, pos);
        this.player = inv.player;
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot(this, this.itemInv, 0, 16, 16, AffixHelper::hasAffixes){

            public int getMaxStackSize() {
                return 1;
            }

            public int getMaxStackSize(ItemStack pStack) {
                return 1;
            }
        });
        this.addSlot((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((AugmentingTableTile)this.tile).inv, 0, 16, 41, stack -> stack.is(Apoth.Items.SIGIL_OF_ENHANCEMENT)));
        this.addPlayerSlots(inv, 8, 140);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && AffixHelper.hasAffixes(stack), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.is(Apoth.Items.SIGIL_OF_ENHANCEMENT), 1, 2);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9, true);
        this.registerInvShuffleRules();
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.clearContainer(pPlayer, (IItemHandler)this.itemInv);
    }

    public boolean clickMenuButton(Player player, int id) {
        int selected = id >> 1;
        ItemStack mainItem = this.getMainItem();
        if (mainItem.isEmpty()) {
            return false;
        }
        List<AffixInstance> affixes = AugmentingMenu.computeItemAffixes(mainItem);
        if (affixes.isEmpty() || selected >= affixes.size()) {
            return false;
        }
        switch (id & 1) {
            case 0: {
                AffixInstance inst = affixes.get(selected);
                if (inst.level() >= 1.0f) {
                    return false;
                }
                ItemStack sigils = this.getSigils();
                if (!this.player.isCreative()) {
                    if (!this.hasUpgradeCost()) {
                        return false;
                    }
                    sigils.shrink(AdventureConfig.upgradeSigilCost);
                    EnchantmentUtils.chargeExperience((Player)player, (int)EnchantmentUtils.getTotalExperienceForLevel((int)AdventureConfig.upgradeLevelCost));
                }
                AffixHelper.applyAffix(mainItem, inst.withNewLevel(Math.min(inst.level() + 0.25f, 1.0f)));
                ((Slot)this.slots.get(0)).set(mainItem);
                player.level().playSound(null, this.pos, SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, player.level().random.nextFloat() * 0.25f + 1.0f);
                player.level().playSound(null, this.pos, SoundEvents.AMETHYST_CLUSTER_STEP, SoundSource.PLAYERS, 0.34f, player.level().random.nextFloat() * 0.2f + 0.8f);
                player.level().playSound(null, this.pos, SoundEvents.SMITHING_TABLE_USE, SoundSource.PLAYERS, 0.45f, player.level().random.nextFloat() * 0.75f + 0.5f);
                return true;
            }
            case 1: {
                AffixInstance inst = affixes.get(selected);
                List<DynamicHolder<Affix>> alternatives = AugmentingMenu.computeAlternatives(mainItem, inst);
                if (alternatives.isEmpty()) {
                    return false;
                }
                ItemStack sigils = this.getSigils();
                if (!this.player.isCreative()) {
                    if (!this.hasRerollCost()) {
                        return false;
                    }
                    sigils.shrink(AdventureConfig.rerollSigilCost);
                    EnchantmentUtils.chargeExperience((Player)player, (int)EnchantmentUtils.getTotalExperienceForLevel((int)AdventureConfig.rerollLevelCost));
                }
                ItemAffixes.Builder builder = ((ItemAffixes)mainItem.getOrDefault(Apoth.Components.AFFIXES, (Object)ItemAffixes.EMPTY)).toBuilder();
                builder.remove(inst.affix());
                GenContext ctx = GenContext.forPlayer(player);
                List<WeightedEntry.Wrapper<Affix>> weighted = AugmentingMenu.getWeightedAffixes(alternatives, ctx);
                DynamicHolder<Affix> newAffix = WeightedRandom.getRandomItem((RandomSource)player.getRandom(), weighted).map(WeightedEntry.Wrapper::data).map(arg_0 -> ((AffixRegistry)AffixRegistry.INSTANCE).holder(arg_0)).orElse(null);
                if (newAffix == null) {
                    newAffix = alternatives.get(player.getRandom().nextInt(alternatives.size()));
                }
                builder.upgrade(newAffix, player.getRandom().nextFloat());
                AffixHelper.setAffixes(mainItem, builder.build());
                ((Slot)this.slots.get(0)).set(mainItem);
                player.level().playSound(null, this.pos, SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, player.level().random.nextFloat() * 0.25f + 1.0f);
                player.level().playSound(null, this.pos, SoundEvents.AMETHYST_CLUSTER_STEP, SoundSource.PLAYERS, 0.34f, player.level().random.nextFloat() * 0.2f + 0.8f);
                player.level().playSound(null, this.pos, SoundEvents.SMITHING_TABLE_USE, SoundSource.PLAYERS, 0.45f, player.level().random.nextFloat() * 0.75f + 0.5f);
                this.broadcastChanges();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new RerollResultPayload(newAffix), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((AugmentingTableTile)this.tile).setChanged();
                return true;
            }
        }
        return false;
    }

    public ItemStack getMainItem() {
        return ((Slot)this.slots.get(0)).getItem();
    }

    public ItemStack getSigils() {
        return ((Slot)this.slots.get(1)).getItem();
    }

    public boolean hasUpgradeCost() {
        return this.getSigils().getCount() >= AdventureConfig.upgradeSigilCost && this.player.experienceLevel >= AdventureConfig.upgradeLevelCost;
    }

    public boolean hasRerollCost() {
        return this.getSigils().getCount() >= AdventureConfig.rerollSigilCost && this.player.experienceLevel >= AdventureConfig.rerollLevelCost;
    }

    public static List<AffixInstance> computeItemAffixes(ItemStack stack) {
        if (!stack.has(Apoth.Components.AFFIXES)) {
            return List.of();
        }
        return AffixHelper.streamAffixes(stack).sorted(Comparator.comparing(inst -> inst.affix().getId())).toList();
    }

    protected static List<DynamicHolder<Affix>> computeAlternatives(ItemStack stack, AffixInstance selected) {
        return LootController.getAlternativeAffixes(stack, selected.getRarity(), selected.affix()).toList();
    }

    protected static List<WeightedEntry.Wrapper<Affix>> getWeightedAffixes(List<DynamicHolder<Affix>> affixes, GenContext ctx) {
        return affixes.stream().map(a -> ((Affix)a.get()).wrap(ctx.tier(), ctx.luck())).toList();
    }
}

