/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.utils.recipes;

import com.pigdad.paganbless.utils.recipes.IngredientWithCount;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public final class RecipeUtils {
    public static List<IngredientWithCount> ingredientsToIWC(List<Ingredient> ingredients) {
        return ingredients.stream().map(ingredient -> new IngredientWithCount((Ingredient)ingredient, 1)).toList();
    }

    public static List<Ingredient> iWCToIngredients(List<SizedIngredient> ingredientsWithCount) {
        return ingredientsWithCount.stream().map(SizedIngredient::ingredient).toList();
    }

    public static List<Ingredient> iWCToIngredientsSaveCount(List<SizedIngredient> ingredientsWithCount) {
        return ingredientsWithCount.stream().map(RecipeUtils::iWCToIngredientSaveCount).toList();
    }

    @NotNull
    public static Ingredient iWCToIngredientSaveCount(SizedIngredient ingredientWithCount) {
        Ingredient ingredient = ingredientWithCount.ingredient();
        for (ItemStack itemStack : ingredient.getItems()) {
            itemStack.setCount(ingredientWithCount.count());
        }
        return ingredient;
    }

    public static <T> NonNullList<T> listToNonNullList(List<T> list) {
        NonNullList nnl = NonNullList.create();
        nnl.addAll(list);
        return nnl;
    }

    public static boolean compareItems(List<ItemStack> inputs, List<SizedIngredient> ingredients) {
        int elements = inputs.size();
        if (elements != ingredients.size()) {
            return false;
        }
        int[] ret = new int[elements];
        Arrays.fill(ret, -1);
        BitSet data = new BitSet((elements + 2) * elements);
        for (int x = 0; x < elements; ++x) {
            int matched = 0;
            int offset = (x + 2) * elements;
            SizedIngredient test = ingredients.get(x);
            for (int y = 0; y < elements; ++y) {
                if (data.get(y) || !test.test(inputs.get(y))) continue;
                data.set(offset + y);
                ++matched;
            }
            if (matched == 0) {
                return false;
            }
            if (matched != true || RecipeUtils.claim(ret, data, x, elements)) continue;
            return false;
        }
        if (data.nextClearBit(0) >= elements) {
            return true;
        }
        return RecipeUtils.backtrack(data, ret, 0, elements);
    }

    private static boolean claim(int[] ret, BitSet data, int claimed, int elements) {
        LinkedList<Integer> pending = new LinkedList<Integer>();
        pending.add(claimed);
        while (pending.peek() != null) {
            int test = (Integer)pending.poll();
            int offset = (test + 2) * elements;
            int used = data.nextSetBit(offset) - offset;
            if (used >= elements || used < 0) {
                throw new IllegalStateException("What? We matched something, but it wasn't set in the range of this test! Test: " + test + " Used: " + used);
            }
            data.set(used);
            data.set(elements + test);
            ret[used] = test;
            for (int x = 0; x < elements; ++x) {
                offset = (x + 2) * elements;
                if (!data.get(offset + used) || data.get(elements + x)) continue;
                data.clear(offset + used);
                int count = 0;
                for (int y = offset; y < offset + elements; ++y) {
                    if (!data.get(y)) continue;
                    ++count;
                }
                if (count == 0) {
                    return false;
                }
                if (count != 1) continue;
                pending.add(x);
            }
        }
        return true;
    }

    private static boolean backtrack(BitSet data, int[] ret, int start, int elements) {
        int test = data.nextClearBit(elements + start) - elements;
        if (test >= elements) {
            return true;
        }
        if (test < 0) {
            throw new IllegalStateException("This should never happen, negative test in backtrack!");
        }
        int offset = (test + 2) * elements;
        for (int x = 0; x < elements; ++x) {
            if (!data.get(offset + x) || data.get(x)) continue;
            data.set(x);
            if (RecipeUtils.backtrack(data, ret, test + 1, elements)) {
                ret[x] = test;
                return true;
            }
            data.clear(x);
        }
        return false;
    }
}

