/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.utils.recipes;

import com.pigdad.paganbless.content.recipes.AnvilSmashingRecipe;
import com.pigdad.paganbless.utils.recipes.PBRecipeInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public final class AnvilRecipeUtils {
    public static void onAnvilLand(Level level, BlockPos blockPos) {
        List entities = level.getEntities(EntityType.ITEM.create(level), new AABB(blockPos));
        ArrayList<ItemEntity> itemEntities = new ArrayList<ItemEntity>();
        for (Entity entity : entities) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            itemEntities.add(itemEntity);
        }
        AnvilRecipeUtils.craftItem(level, itemEntities, blockPos);
    }

    private static void craftItem(Level level, List<ItemEntity> itemEntities, BlockPos blockPos) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(itemEntities.size());
        for (ItemEntity entity : itemEntities) {
            itemStacks.add(entity.getItem());
        }
        PBRecipeInput recipeInput = new PBRecipeInput(itemStacks);
        Optional<RecipeHolder<AnvilSmashingRecipe>> optionalRecipe = AnvilRecipeUtils.getCurrentRecipe(level, recipeInput);
        optionalRecipe.ifPresent(anvilSmashingRecipe -> {
            ItemStack resultItem = ((AnvilSmashingRecipe)anvilSmashingRecipe.value()).result().copy();
            for (ItemEntity itemEntity : itemEntities) {
                for (Ingredient ingredient : ((AnvilSmashingRecipe)anvilSmashingRecipe.value()).getIngredients()) {
                    if (!ingredient.test(itemEntity.getItem())) continue;
                    int count = ingredient.getItems()[0].getCount();
                    itemEntity.getItem().shrink(count);
                }
            }
            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)resultItem);
        });
    }

    private static Optional<RecipeHolder<AnvilSmashingRecipe>> getCurrentRecipe(Level level, PBRecipeInput container) {
        return level.getRecipeManager().getRecipeFor((RecipeType)AnvilSmashingRecipe.Type.INSTANCE, (RecipeInput)container, level);
    }
}

