/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.utils;

import com.pigdad.paganbless.content.blockentities.WinchBlockEntity;
import com.pigdad.paganbless.content.blocks.RopeBlock;
import com.pigdad.paganbless.utils.recipes.AnvilRecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public final class WinchUtils {
    public static int recheckConnections(Level level, BlockPos winchPos, @Nullable BlockPos excludedPosition) {
        int length = 0;
        BlockPos blockPos = winchPos.below();
        while (level.getBlockState(blockPos).getBlock() instanceof RopeBlock && RopeBlock.facingUpOrDown((Direction)level.getBlockState(blockPos).getValue((Property)RopeBlock.FACING)) || blockPos.equals((Object)excludedPosition)) {
            BlockState ropeBlock = level.getBlockState(blockPos);
            if (!blockPos.equals((Object)excludedPosition)) {
                level.setBlockAndUpdate(blockPos, (BlockState)ropeBlock.setValue((Property)RopeBlock.HAS_WINCH, (Comparable)Boolean.valueOf(true)));
            }
            blockPos = blockPos.below();
            ++length;
        }
        return length;
    }

    public static void liftDown(WinchBlockEntity winchBlockEntity) {
        BlockPos winchPos = winchBlockEntity.getBlockPos();
        Level level = winchBlockEntity.getLevel();
        int distance = winchBlockEntity.getDistance();
        BlockPos lastRopePos = winchPos.below(distance);
        BlockPos liftedPos = lastRopePos.below();
        BlockPos belowLiftedPos = liftedPos.below();
        BlockState liftedState = level.getBlockState(liftedPos);
        BlockState belowLiftedState = level.getBlockState(belowLiftedPos);
        if (liftedState.hasBlockEntity() || liftedState.getPistonPushReaction() != PushReaction.NORMAL && !liftedState.isEmpty() && !liftedState.is(Blocks.ANVIL)) {
            return;
        }
        ItemStackHandler itemHandler = winchBlockEntity.getItemHandler();
        ItemStack stackInSlot = itemHandler.getStackInSlot(0);
        if (!stackInSlot.isEmpty()) {
            BlockState newRopeState = Block.byItem((Item)stackInSlot.getItem()).defaultBlockState();
            if (!newRopeState.isEmpty()) {
                if (liftedState.isAir()) {
                    level.setBlockAndUpdate(liftedPos, (BlockState)newRopeState.setValue((Property)RopeBlock.FACING, (Comparable)Direction.DOWN));
                    winchBlockEntity.setDistance(distance + 1);
                    winchBlockEntity.setLiftDown(true);
                    itemHandler.extractItem(0, 1, false);
                } else if (belowLiftedState.canBeReplaced()) {
                    if (!(liftedState.getBlock() instanceof RopeBlock)) {
                        level.setBlockAndUpdate(belowLiftedPos, liftedState);
                    }
                    level.setBlockAndUpdate(liftedPos, (BlockState)newRopeState.setValue((Property)RopeBlock.FACING, (Comparable)Direction.DOWN));
                    winchBlockEntity.setDistance(distance + 1);
                    winchBlockEntity.setLiftDown(true);
                    itemHandler.extractItem(0, 1, false);
                } else {
                    winchBlockEntity.setLiftDown(false);
                    if (liftedState.is(Blocks.ANVIL)) {
                        level.playSound(null, belowLiftedPos, SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 2.0f, 1.0f);
                        AnvilRecipeUtils.onAnvilLand(level, belowLiftedPos);
                    }
                }
            }
        } else {
            winchBlockEntity.setLiftDown(false);
        }
    }

    public static void liftUp(WinchBlockEntity winchBlockEntity) {
        ItemStack remainder;
        BlockPos winchPos = winchBlockEntity.getBlockPos();
        Level level = winchBlockEntity.getLevel();
        int distance = winchBlockEntity.getDistance();
        BlockPos lastRopePos = winchPos.below(distance);
        BlockState lastRopeState = level.getBlockState(lastRopePos);
        BlockPos liftedPos = lastRopePos.below();
        BlockState liftedState = level.getBlockState(liftedPos);
        ItemStack newRopeStack = lastRopeState.getBlock().asItem().getDefaultInstance();
        if (!newRopeStack.isEmpty() && !liftedState.hasBlockEntity() && distance > 1 && (remainder = winchBlockEntity.getItemHandler().insertItem(0, newRopeStack, false)).isEmpty()) {
            level.removeBlock(liftedPos, true);
            level.setBlockAndUpdate(lastRopePos, liftedState);
            winchBlockEntity.setDistance(distance - 1);
        }
    }
}

