/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.networking;

import com.pigdad.paganbless.content.blockentities.IncenseBlockEntity;
import com.pigdad.paganbless.content.blockentities.RunicCoreBlockEntity;
import com.pigdad.paganbless.content.blockentities.WinchBlockEntity;
import com.pigdad.paganbless.networking.IncenseBurningPayload;
import com.pigdad.paganbless.networking.RunicCoreExplodePayload;
import com.pigdad.paganbless.networking.RunicCoreRecipePayload;
import com.pigdad.paganbless.networking.WinchPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PayloadActions {
    public static void runicCoreRecipeSync(RunicCoreRecipePayload payload, IPayloadContext ctx) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockEntity blockEntity = level.getBlockEntity(payload.runicCorePos());
        if (blockEntity instanceof RunicCoreBlockEntity) {
            RunicCoreBlockEntity runicCoreBlockEntity = (RunicCoreBlockEntity)blockEntity;
            runicCoreBlockEntity.setRunRecipe(payload.runRecipe());
            runicCoreBlockEntity.setRuneSlabs(payload.blockPoses());
        }
    }

    public static void runicCoreExplodeSync(RunicCoreExplodePayload payload, IPayloadContext ctx) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos blockPos = payload.blockPos();
        level.explode(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 100.0f, Level.ExplosionInteraction.NONE);
    }

    public static void incenseBurningSync(IncenseBurningPayload payload, IPayloadContext ctx) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos blockPos = payload.blockPos();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof IncenseBlockEntity) {
            IncenseBlockEntity incenseBlockEntity = (IncenseBlockEntity)blockEntity;
            incenseBlockEntity.setBurning(payload.burning());
            incenseBlockEntity.setBurningProgress(payload.burningProgress());
        }
    }

    public static void winchSync(WinchPayload payload, IPayloadContext ctx) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos blockPos = payload.blockPos();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof WinchBlockEntity) {
            WinchBlockEntity winchBlockEntity = (WinchBlockEntity)blockEntity;
            winchBlockEntity.setLiftDown(payload.liftDown());
            winchBlockEntity.setDistance(payload.distance());
        }
    }
}

