/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.datagen.recipe_builder;

import com.pigdad.paganbless.content.recipes.ImbuingCauldronRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImbuingCauldronRecipeBuilder
implements RecipeBuilder {
    @NotNull
    private final List<SizedIngredient> ingredients = new ArrayList<SizedIngredient>();
    @Nullable
    private final SizedFluidIngredient fluid;
    @NotNull
    private final ItemStack result;

    private ImbuingCauldronRecipeBuilder(ItemStack result, SizedFluidIngredient fluidStack) {
        this.fluid = fluidStack;
        this.result = result;
    }

    public static ImbuingCauldronRecipeBuilder newRecipe(ItemStack result, SizedFluidIngredient fluidStack) {
        return new ImbuingCauldronRecipeBuilder(result, fluidStack);
    }

    public static ImbuingCauldronRecipeBuilder newRecipe(ItemStack result) {
        return ImbuingCauldronRecipeBuilder.newRecipe(result, null);
    }

    @NotNull
    public ImbuingCauldronRecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return this;
    }

    public ImbuingCauldronRecipeBuilder ingredients(SizedIngredient ... ingredients) {
        this.ingredients.addAll(Arrays.stream(ingredients).toList());
        return this;
    }

    public ImbuingCauldronRecipeBuilder ingredients(ItemStack ... items) {
        this.ingredients.addAll(Arrays.stream(items).map(itemStack -> SizedIngredient.of((ItemLike)itemStack.getItem(), (int)itemStack.getCount())).toList());
        return this;
    }

    public ImbuingCauldronRecipeBuilder ingredients(ItemLike ... items) {
        this.ingredients.addAll(Arrays.stream(items).map(item -> SizedIngredient.of((ItemLike)item, (int)1)).toList());
        return this;
    }

    @SafeVarargs
    public final ImbuingCauldronRecipeBuilder ingredients(TagKey<Item> ... items) {
        this.ingredients.addAll(Arrays.stream(items).map(item -> SizedIngredient.of((TagKey)item, (int)1)).toList());
        return this;
    }

    @NotNull
    public ImbuingCauldronRecipeBuilder group(@Nullable String group) {
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        ImbuingCauldronRecipe recipe = new ImbuingCauldronRecipe(this.ingredients, this.result, Optional.ofNullable(this.fluid));
        recipeOutput.accept(resourceLocation, (Recipe)recipe, null);
    }
}

