/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.datagen;

import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.registries.PBItems;
import com.pigdad.paganbless.registries.PBTags;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PBTagProvider {

    public static class BlocksProvider
    extends BlockTagsProvider {
        public BlocksProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "paganbless", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag((TagKey<Block>)BlockTags.LEAVES, PBBlocks.BLACK_THORN_LEAVES.get());
            this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, PBBlocks.IMBUING_CAULDRON.get(), PBBlocks.EMPTY_INCENSE.get(), PBBlocks.HERBALIST_BENCH.get(), PBBlocks.CRANK.get(), PBBlocks.WINCH.get(), PBBlocks.RUE_INCENSE.get(), PBBlocks.LAVENDER_INCENSE.get());
            this.tag((TagKey<Block>)BlockTags.LOGS_THAT_BURN, PBBlocks.BLACK_THORN_LOG.get(), PBBlocks.STRIPPED_BLACK_THORN_LOG.get(), PBBlocks.ESSENCE_BLACK_THORN_LOG.get(), PBBlocks.BLACK_THORN_WOOD.get(), PBBlocks.STRIPPED_BLACK_THORN_WOOD.get());
            this.tag((TagKey<Block>)BlockTags.PLANKS, PBBlocks.BLACK_THORN_PLANKS.get());
            this.tag((TagKey<Block>)BlockTags.WOODEN_BUTTONS, PBBlocks.BLACK_THORN_BUTTON.get());
            this.tag((TagKey<Block>)BlockTags.WOODEN_DOORS, PBBlocks.BLACK_THORN_DOOR.get());
            this.tag((TagKey<Block>)BlockTags.WOODEN_FENCES, PBBlocks.BLACK_THORN_FENCE.get());
            this.tag((TagKey<Block>)BlockTags.FENCE_GATES, PBBlocks.BLACK_THORN_FENCE_GATE.get());
            this.tag((TagKey<Block>)BlockTags.WOODEN_SLABS, PBBlocks.BLACK_THORN_SLAB.get());
            this.tag((TagKey<Block>)BlockTags.WOODEN_STAIRS, PBBlocks.BLACK_THORN_STAIRS.get());
            this.tag((TagKey<Block>)BlockTags.WOODEN_TRAPDOORS, PBBlocks.BLACK_THORN_TRAPDOOR.get());
            this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE, PBBlocks.RUNIC_CORE.get(), PBBlocks.CRANK.get());
            for (Supplier<Block> block : PBBlocks.WOOD_BLOCKS) {
                this.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE, block.get());
            }
        }

        @NotNull
        private IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> tag(TagKey<Block> blockTagKey, Block ... blocks) {
            return this.tag(blockTagKey).add((Object[])blocks);
        }
    }

    public static class ItemsProvider
    extends ItemTagsProvider {
        public ItemsProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> pBlockTags) {
            super(pOutput, pLookupProvider, pBlockTags);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(PBTags.ItemTags.PAGAN_TOOLS, (ItemLike)PBItems.BLACK_THORN_STAFF.get(), (ItemLike)PBItems.BOLINE.get());
            this.tag(PBTags.ItemTags.FIRE_LIGHTER, new ItemLike[]{Items.FLINT_AND_STEEL});
            this.tag(PBTags.ItemTags.GEMS_CINNABAR, (ItemLike)PBItems.CINNABAR.get());
            this.tag((TagKey<Item>)Tags.Items.RODS_WOODEN, (ItemLike)PBItems.BLACK_THORN_STICK.get());
            this.tag(PBTags.ItemTags.HANGING_HERBS, new ItemLike[]{PBBlocks.HANGING_RUE.get().asItem(), PBBlocks.HANGING_LAVENDER.get().asItem()});
            this.tag(PBTags.ItemTags.DRIED_HERBS, new ItemLike[]{PBBlocks.DRIED_HANGING_RUE.get().asItem(), PBBlocks.DRIED_HANGING_LAVENDER.get().asItem()});
            this.tag(PBTags.ItemTags.WAXED_HERBS, new ItemLike[]{PBBlocks.WAXED_HANGING_RUE.get().asItem(), PBBlocks.WAXED_HANGING_LAVENDER.get().asItem()});
            this.tag(PBTags.ItemTags.CHOPPED_HERBS, new ItemLike[]{PBItems.CHOPPED_RUE.get().asItem(), PBItems.CHOPPED_LAVENDER.get().asItem()});
            this.tag(PBTags.ItemTags.ROPE_HERBS, (ItemLike)PBItems.RUE.get(), (ItemLike)PBItems.LAVENDER.get());
            this.tag(PBTags.ItemTags.HERB_PLANTS, new ItemLike[]{PBBlocks.BELLADONNA_PLANT.get().asItem(), PBBlocks.HAGS_TAPER_PLANT.get().asItem(), PBBlocks.LAVENDER_PLANT.get().asItem(), PBBlocks.MANDRAKE_ROOT_PLANT.get().asItem(), PBBlocks.MUGWORT_PLANT.get().asItem(), PBBlocks.RUE_PLANT.get().asItem(), (ItemLike)PBItems.WINTER_BERRIES.get()});
            this.tag(PBTags.ItemTags.HERBS, (ItemLike)PBItems.LAVENDER.get(), (ItemLike)PBItems.RUE.get(), (ItemLike)PBItems.BELLADONNA.get(), (ItemLike)PBItems.HAG_TAPER.get(), (ItemLike)PBItems.MUGWORT.get(), (ItemLike)PBItems.MANDRAKE_ROOT.get(), (ItemLike)PBItems.WINTER_BERRIES.get());
            this.tag((TagKey<Item>)ItemTags.LOGS_THAT_BURN, (ItemLike)PBBlocks.BLACK_THORN_LOG.get(), (ItemLike)PBBlocks.STRIPPED_BLACK_THORN_LOG.get(), (ItemLike)PBBlocks.STRIPPED_BLACK_THORN_LOG.get(), (ItemLike)PBBlocks.BLACK_THORN_WOOD.get(), (ItemLike)PBBlocks.ESSENCE_BLACK_THORN_LOG.get(), (ItemLike)PBBlocks.STRIPPED_BLACK_THORN_WOOD.get());
            this.tag((TagKey<Item>)ItemTags.PLANKS, (ItemLike)PBBlocks.BLACK_THORN_PLANKS.get());
            this.tag((TagKey<Item>)ItemTags.WOODEN_BUTTONS, (ItemLike)PBBlocks.BLACK_THORN_BUTTON.get());
            this.tag((TagKey<Item>)ItemTags.WOODEN_DOORS, (ItemLike)PBBlocks.BLACK_THORN_DOOR.get());
            this.tag((TagKey<Item>)ItemTags.WOODEN_FENCES, (ItemLike)PBBlocks.BLACK_THORN_FENCE.get());
            this.tag((TagKey<Item>)ItemTags.FENCE_GATES, (ItemLike)PBBlocks.BLACK_THORN_FENCE_GATE.get());
            this.tag((TagKey<Item>)ItemTags.WOODEN_SLABS, (ItemLike)PBBlocks.BLACK_THORN_SLAB.get());
            this.tag((TagKey<Item>)ItemTags.WOODEN_STAIRS, (ItemLike)PBBlocks.BLACK_THORN_STAIRS.get());
            this.tag((TagKey<Item>)ItemTags.WOODEN_TRAPDOORS, (ItemLike)PBBlocks.BLACK_THORN_TRAPDOOR.get());
            if (PBItems.PAGAN_GUIDE != null) {
                this.tag((TagKey<Item>)ItemTags.BOOKSHELF_BOOKS, (ItemLike)PBItems.PAGAN_GUIDE.get());
            }
        }

        @NotNull
        private IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag(TagKey<Item> itemTagKey, ItemLike ... items) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(itemTagKey);
            for (ItemLike item : items) {
                tag.add((Object)item.asItem());
            }
            return tag;
        }
    }
}

