/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.datagen;

import com.pigdad.paganbless.content.blocks.EssenceLogBlock;
import com.pigdad.paganbless.content.blocks.WaxedHangingHerbBlock;
import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.registries.PBItems;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class PBLootTableProvider
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();

    protected PBLootTableProvider(HolderLookup.Provider provider) {
        super(Collections.emptySet(), FeatureFlags.VANILLA_SET, provider);
    }

    protected void add(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    protected void generate() {
        this.dropSelf(PBBlocks.IMBUING_CAULDRON.get());
        this.dropSelf(PBBlocks.HERBALIST_BENCH.get());
        this.dropSelf(PBBlocks.WINCH.get());
        this.dropSelf(PBBlocks.CRANK.get());
        this.dropSelf(PBBlocks.ROPE.get());
        this.dropSelf(PBBlocks.RUNIC_CORE.get());
        this.dropSelf(PBBlocks.WICAN_WARD.get());
        this.dropSelf(PBBlocks.PENTACLE.get());
        this.dropSelf(PBBlocks.EMPTY_INCENSE.get());
        this.dropOther(PBBlocks.LAVENDER_INCENSE.get(), (ItemLike)PBBlocks.EMPTY_INCENSE.get());
        this.dropOther(PBBlocks.RUE_INCENSE.get(), (ItemLike)PBBlocks.EMPTY_INCENSE.get());
        this.dropSelf(PBBlocks.RUNE_SLAB_INERT.get());
        this.dropSelf(PBBlocks.RUNE_SLAB_AMETHYST.get());
        this.dropSelf(PBBlocks.RUNE_SLAB_QUARTZ.get());
        this.dropSelf(PBBlocks.RUNE_SLAB_LAPIS.get());
        this.dropSelf(PBBlocks.RUNE_SLAB_EMERALD.get());
        this.dropSelf(PBBlocks.RUNE_SLAB_DIAMOND.get());
        this.dropSelf(PBBlocks.RUNE_SLAB_QUARTZ.get());
        this.dropSelf(PBBlocks.HANGING_LAVENDER.get());
        this.dropSelf(PBBlocks.HANGING_RUE.get());
        this.dropSelf(PBBlocks.DRIED_HANGING_LAVENDER.get());
        this.dropSelf(PBBlocks.DRIED_HANGING_RUE.get());
        this.dropWaxedHangingHerb(PBBlocks.WAXED_HANGING_LAVENDER.get());
        this.dropWaxedHangingHerb(PBBlocks.WAXED_HANGING_RUE.get());
        this.dropHerbPlant(PBBlocks.BELLADONNA_PLANT.get(), (ItemLike)PBItems.BELLADONNA.get());
        this.dropHerbPlant(PBBlocks.RUE_PLANT.get(), (ItemLike)PBItems.RUE.get());
        this.dropHerbPlant(PBBlocks.MUGWORT_PLANT.get(), (ItemLike)PBItems.MUGWORT.get());
        this.dropHerbPlant(PBBlocks.MANDRAKE_ROOT_PLANT.get(), (ItemLike)PBItems.MANDRAKE_ROOT.get());
        this.dropHerbPlant(PBBlocks.LAVENDER_PLANT.get(), (ItemLike)PBItems.LAVENDER.get());
        this.dropHerbPlant(PBBlocks.HAGS_TAPER_PLANT.get(), (ItemLike)PBItems.HAG_TAPER.get());
        for (Supplier<Block> block : PBBlocks.WOOD_BLOCKS) {
            if (block.get() instanceof EssenceLogBlock) {
                this.dropOther(block.get(), (ItemLike)PBBlocks.BLACK_THORN_LOG.get());
                continue;
            }
            this.dropSelf(block.get());
        }
        this.add(PBBlocks.BLACK_THORN_LEAVES.get(), this.createLeavesDrops(PBBlocks.BLACK_THORN_LEAVES.get(), PBBlocks.BLACK_THORN_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf(PBBlocks.BLACK_THORN_SAPLING.get());
        this.dropCinnabarFromRedstone(Blocks.REDSTONE_ORE);
        this.dropCinnabarFromRedstone(Blocks.DEEPSLATE_REDSTONE_ORE);
    }

    protected void dropCinnabarFromRedstone(Block redstoneOre) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.add(redstoneOre, this.createSilkTouchDispatchTable(redstoneOre, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)redstoneOre, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)PBItems.CINNABAR.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }

    protected void dropHerbPlant(Block block, ItemLike item) {
        this.add(block, this.createShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (int)2)))));
    }

    protected void dropWaxedHangingHerb(Block waxedHangingHerbBlock) {
        this.add(waxedHangingHerbBlock, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)waxedHangingHerbBlock, LootItem.lootTableItem((ItemLike)waxedHangingHerbBlock).apply(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), i -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)i.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)waxedHangingHerbBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)WaxedHangingHerbBlock.HANGING_AMOUNT, i.intValue()))))))));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return HAS_SHEARS.or(this.hasSilkTouch());
    }
}

