/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.screens;

import com.pigdad.paganbless.PaganBless;
import com.pigdad.paganbless.api.screen.PBAbstractContainerMenu;
import com.pigdad.paganbless.content.blockentities.WinchBlockEntity;
import com.pigdad.paganbless.registries.PBMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class WinchMenu
extends PBAbstractContainerMenu<WinchBlockEntity> {
    private int slotAmount;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;

    public WinchMenu(int containerId, Inventory inv, WinchBlockEntity blockEntity) {
        super(PBMenuTypes.WINCH_MENU.get(), containerId, inv, blockEntity);
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItemHandler(), 0, 80, 36));
    }

    public WinchMenu(int containerId, Inventory inv, FriendlyByteBuf byteBuf) {
        this(containerId, inv, (WinchBlockEntity)inv.player.level().getBlockEntity(byteBuf.readBlockPos()));
    }

    protected Slot addSlot(Slot slot) {
        ++this.slotAmount;
        return super.addSlot(slot);
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        try {
            Slot sourceSlot = (Slot)this.slots.get(pIndex);
            if (!sourceSlot.hasItem()) {
                return ItemStack.EMPTY;
            }
            ItemStack sourceStack = sourceSlot.getItem();
            ItemStack copyOfSourceStack = sourceStack.copy();
            int endIndex = 36 + this.slotAmount - 36;
            if (pIndex < 36) {
                if (!this.moveItemStackTo(sourceStack, 36, endIndex, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (pIndex < endIndex) {
                if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                PaganBless.LOGGER.error("Invalid slotIndex for quickinsert: {}", (Object)pIndex);
                return ItemStack.EMPTY;
            }
            if (sourceStack.getCount() == 0) {
                sourceSlot.set(ItemStack.EMPTY);
            } else {
                sourceSlot.setChanged();
            }
            sourceSlot.onTake(playerIn, sourceStack);
            return copyOfSourceStack;
        }
        catch (Exception e) {
            PaganBless.LOGGER.error("Encountered error: ", (Throwable)e);
            return ItemStack.EMPTY;
        }
    }
}

