/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pigdad.paganbless.utils.recipes.PBFluidRecipeInput;
import com.pigdad.paganbless.utils.recipes.RecipeUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ImbuingCauldronRecipe(List<SizedIngredient> ingredients, ItemStack result, Optional<SizedFluidIngredient> fluidIngredient) implements Recipe<PBFluidRecipeInput>
{
    public static final String NAME = "cauldron_imbuing";

    public boolean matches(@NotNull PBFluidRecipeInput recipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        List<ItemStack> inputItems = recipeInput.items().stream().filter(input -> !input.isEmpty()).toList();
        boolean fluidMatches = this.fluidIngredient.isEmpty() || this.fluidIngredient.get().test(recipeInput.fluidStack());
        boolean itemsMatches = RecipeUtils.compareItems(inputItems, this.ingredients);
        return itemsMatches && fluidMatches;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return RecipeUtils.listToNonNullList(RecipeUtils.iWCToIngredientsSaveCount(this.ingredients));
    }

    @NotNull
    public NonNullList<SizedIngredient> getIngredientsWithCount() {
        return RecipeUtils.listToNonNullList(this.ingredients);
    }

    @NotNull
    public ItemStack assemble(@NotNull PBFluidRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ImbuingCauldronRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<ImbuingCauldronRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(ImbuingCauldronRecipe::ingredients), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(ImbuingCauldronRecipe::result), (App)SizedFluidIngredient.FLAT_CODEC.optionalFieldOf("fluid").forGetter(ImbuingCauldronRecipe::fluidIngredient)).apply((Applicative)builder, ImbuingCauldronRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ImbuingCauldronRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), ImbuingCauldronRecipe::ingredients, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ImbuingCauldronRecipe::result, (StreamCodec)ByteBufCodecs.optional((StreamCodec)SizedFluidIngredient.STREAM_CODEC), ImbuingCauldronRecipe::fluidIngredient, ImbuingCauldronRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<ImbuingCauldronRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ImbuingCauldronRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<ImbuingCauldronRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return ImbuingCauldronRecipe.NAME;
        }
    }
}

