/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.items;

import com.pigdad.paganbless.content.entities.WandProjectileEntity;
import com.pigdad.paganbless.registries.PBItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class WandItem
extends Item {
    public WandItem(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (!pLevel.isClientSide() && pTimeCharged <= this.getUseDuration(pStack, pLivingEntity) - 15) {
            WandProjectileEntity wandProjectile = new WandProjectileEntity(pLevel, pLivingEntity);
            wandProjectile.setItem(PBItems.WAND_PROJECTILE.get().getDefaultInstance());
            wandProjectile.shootFromRotation((Entity)pLivingEntity, pLivingEntity.getXRot(), pLivingEntity.getYRot(), 0.0f, 1.5f, 1.0f);
            pLevel.addFreshEntity((Entity)wandProjectile);
        }
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 72000;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        pPlayer.startUsingItem(pUsedHand);
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public static void applyBonemeal(Level level, BlockPos hitPos, Direction face) {
        BlockPos blockpos1 = hitPos.relative(face);
        if (WandItem.applyBonemeal(level, hitPos)) {
            if (!level.isClientSide) {
                level.levelEvent(1505, hitPos, 15);
            }
        } else {
            BlockState blockstate = level.getBlockState(hitPos);
            boolean flag = blockstate.isFaceSturdy((BlockGetter)level, hitPos, face);
            if (flag && WandItem.growWaterPlant(level, blockpos1, face) && !level.isClientSide) {
                level.levelEvent(1505, blockpos1, 15);
            }
        }
    }

    private static boolean applyBonemeal(Level level, BlockPos p_40630_) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = level.getBlockState(p_40630_);
        Block var7 = blockstate.getBlock();
        if (var7 instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)var7).isValidBonemealTarget((LevelReader)level, p_40630_, blockstate)) {
            if (level instanceof ServerLevel && bonemealableblock.isBonemealSuccess(level, level.random, p_40630_, blockstate)) {
                bonemealableblock.performBonemeal((ServerLevel)level, level.random, p_40630_, blockstate);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(Level p_40633_, BlockPos p_40634_, @Nullable Direction p_40635_) {
        if (p_40633_.getBlockState(p_40634_).is(Blocks.WATER) && p_40633_.getFluidState(p_40634_).getAmount() == 8) {
            if (p_40633_ instanceof ServerLevel) {
                RandomSource randomsource = p_40633_.getRandom();
                block0: for (int i = 0; i < 128; ++i) {
                    BlockPos blockpos = p_40634_;
                    BlockState blockstate = Blocks.SEAGRASS.defaultBlockState();
                    for (int j = 0; j < i / 16; ++j) {
                        if (p_40633_.getBlockState(blockpos = blockpos.offset(randomsource.nextInt(3) - 1, (randomsource.nextInt(3) - 1) * randomsource.nextInt(3) / 2, randomsource.nextInt(3) - 1)).isCollisionShapeFullBlock((BlockGetter)p_40633_, blockpos)) continue block0;
                    }
                    Holder holder = p_40633_.getBiome(blockpos);
                    if (holder.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL)) {
                        if (i == 0 && p_40635_ != null && p_40635_.getAxis().isHorizontal()) {
                            blockstate = BuiltInRegistries.BLOCK.getTag(BlockTags.WALL_CORALS).flatMap(p_204098_ -> p_204098_.getRandomElement(p_40633_.random)).map(p_204100_ -> ((Block)p_204100_.value()).defaultBlockState()).orElse(blockstate);
                            if (blockstate.hasProperty((Property)BaseCoralWallFanBlock.FACING)) {
                                blockstate = (BlockState)blockstate.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)p_40635_);
                            }
                        } else if (randomsource.nextInt(4) == 0) {
                            blockstate = BuiltInRegistries.BLOCK.getTag(BlockTags.UNDERWATER_BONEMEALS).flatMap(p_204091_ -> p_204091_.getRandomElement(p_40633_.random)).map(p_204095_ -> ((Block)p_204095_.value()).defaultBlockState()).orElse(blockstate);
                        }
                    }
                    if (blockstate.is(BlockTags.WALL_CORALS, p_204093_ -> p_204093_.hasProperty((Property)BaseCoralWallFanBlock.FACING))) {
                        for (int k = 0; !blockstate.canSurvive((LevelReader)p_40633_, blockpos) && k < 4; ++k) {
                            blockstate = (BlockState)blockstate.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(randomsource));
                        }
                    }
                    if (!blockstate.canSurvive((LevelReader)p_40633_, blockpos)) continue;
                    BlockState blockstate1 = p_40633_.getBlockState(blockpos);
                    if (blockstate1.is(Blocks.WATER) && p_40633_.getFluidState(blockpos).getAmount() == 8) {
                        p_40633_.setBlock(blockpos, blockstate, 3);
                        continue;
                    }
                    if (!blockstate1.is(Blocks.SEAGRASS) || randomsource.nextInt(10) != 0) continue;
                    ((BonemealableBlock)Blocks.SEAGRASS).performBonemeal((ServerLevel)p_40633_, randomsource, blockpos, blockstate1);
                }
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"wand.desc.0").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }
}

