/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.entities;

import com.pigdad.paganbless.PBConfig;
import com.pigdad.paganbless.content.items.WandItem;
import com.pigdad.paganbless.registries.PBItems;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class WandProjectileEntity
extends Snowball {
    public WandProjectileEntity(EntityType<? extends Snowball> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
    }

    public WandProjectileEntity(Level p_37399_, LivingEntity p_37400_) {
        super(p_37399_, p_37400_);
    }

    @NotNull
    protected Item getDefaultItem() {
        return PBItems.WAND_PROJECTILE.get();
    }

    protected void onHitEntity(EntityHitResult p_37404_) {
        Animal animal;
        Entity entity = p_37404_.getEntity();
        if (entity instanceof Animal && (animal = (Animal)entity).isBaby()) {
            animal.ageUp(AgeableMob.getSpeedUpSecondsWhenFeeding((int)(-animal.getAge())), true);
        }
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)PBConfig.wandProjectileDamage);
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        WandItem.applyBonemeal(this.level(), pResult.getBlockPos(), pResult.getDirection());
    }
}

