/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.PBConfig;
import com.pigdad.paganbless.api.blocks.IncenseBlock;
import com.pigdad.paganbless.registries.PBItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class LavenderIncenseBlock
extends IncenseBlock {
    public LavenderIncenseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public void effectTick(Level level, BlockPos blockPos, BlockState blockState) {
        int range = this.getRange(level, blockPos, blockState);
        for (LivingEntity livingEntity : LavenderIncenseBlock.getNearbyEntities(level, blockPos, range)) {
            if (livingEntity.hasEffect(MobEffects.REGENERATION)) continue;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 40, 1, false, false));
        }
    }

    @NotNull
    private static List<LivingEntity> getNearbyEntities(Level level, BlockPos blockPos, int range) {
        return level.getEntitiesOfClass(LivingEntity.class, new AABB(blockPos).deflate((double)range));
    }

    @Override
    public int getRange(Level level, BlockPos blockPos, BlockState blockState) {
        return PBConfig.lavenderIncenseRange;
    }

    @Override
    public Item getIncenseItem() {
        return PBItems.CHOPPED_LAVENDER.get();
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return LavenderIncenseBlock.simpleCodec(LavenderIncenseBlock::new);
    }
}

