/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blockentities.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pigdad.paganbless.api.blocks.RotatableEntityBlock;
import com.pigdad.paganbless.content.blockentities.HerbalistBenchBlockEntity;
import com.pigdad.paganbless.registries.PBTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class HerbalistBenchBERenderer
implements BlockEntityRenderer<HerbalistBenchBlockEntity> {
    public HerbalistBenchBERenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(HerbalistBenchBlockEntity blockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)RotatableEntityBlock.FACING);
        ItemStack boardStack = blockEntity.getItemHandler().getStackInSlot(0);
        ItemStack toolStack = blockEntity.getItemHandler().getStackInSlot(1);
        Vector3f toolPos = switch (facing) {
            case Direction.NORTH -> new Vector3f(-0.3f, 1.0f, 0.4f);
            case Direction.EAST -> new Vector3f(0.6f, 1.0f, -0.3f);
            case Direction.SOUTH -> new Vector3f(1.35f, 1.0f, 0.6f);
            case Direction.WEST -> new Vector3f(0.4f, 1.0f, 1.35f);
            default -> null;
        };
        Vector3f boardItemPos = switch (facing) {
            case Direction.NORTH -> new Vector3f(0.5f, 1.075f, 0.4f);
            case Direction.EAST -> new Vector3f(0.6f, 1.075f, 0.5f);
            case Direction.SOUTH -> new Vector3f(0.5f, 1.075f, 0.6f);
            case Direction.WEST -> new Vector3f(0.4f, 1.075f, 0.5f);
            default -> null;
        };
        HerbalistBenchBERenderer.renderItem(blockEntity, poseStack, multiBufferSource, facing, renderer, boardStack, boardItemPos.x, boardItemPos.y, boardItemPos.z, boardStack.is(PBTags.ItemTags.DRIED_HERBS));
        HerbalistBenchBERenderer.renderItem(blockEntity, poseStack, multiBufferSource, facing, renderer, toolStack, toolPos.x, toolPos.y, toolPos.z, false);
    }

    private static void renderItem(HerbalistBenchBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, Direction facing, ItemRenderer renderer, ItemStack itemStack, float x, float y, float z, boolean useHangingHerbRotation) {
        if (itemStack != null && !itemStack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            poseStack.scale(0.65f, 0.65f, 0.65f);
            float yRot = facing.getOpposite().toYRot() + (float)(useHangingHerbRotation ? 90 : 0);
            poseStack.mulPose(Axis.YN.rotationDegrees(yRot));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            renderer.renderStatic(itemStack, ItemDisplayContext.FIXED, HerbalistBenchBERenderer.getLightLevel(blockEntity.getLevel(), blockEntity.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, blockEntity.getLevel(), 1);
            poseStack.popPose();
        }
    }

    private static int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

