/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blockentities;

import com.pigdad.paganbless.content.blockentities.WinchBlockEntity;
import com.pigdad.paganbless.content.blocks.CrankBlock;
import com.pigdad.paganbless.registries.PBBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CrankBlockEntity
extends BlockEntity {
    public float independentAngle;
    public float chasingVelocity;
    public int inUse;
    public int speed = 0;
    public boolean dropping;

    public CrankBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(PBBlockEntities.CRANK.get(), pPos, pBlockState);
    }

    public void turn() {
        this.inUse = 10;
        this.speed = 1200;
    }

    public void drop() {
        this.speed = -4000;
        this.dropping = true;
    }

    public void tick() {
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0 && !this.dropping) {
            --this.inUse;
            if (this.inUse == 0) {
                this.speed = 0;
            }
        } else if (this.dropping) {
            WinchBlockEntity winchBlockEntity;
            BlockPos winchPos = CrankBlock.getWinchPos(this.getBlockState(), this.getBlockPos());
            assert (this.level != null);
            BlockEntity blockEntity = this.level.getBlockEntity(winchPos);
            if (blockEntity instanceof WinchBlockEntity && !(winchBlockEntity = (WinchBlockEntity)blockEntity).isLiftDown()) {
                this.speed = 0;
                this.dropping = false;
            }
        }
    }

    private float getSpeed() {
        return this.speed;
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }
}

