/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.compat.jei;

import com.pigdad.paganbless.compat.jei.AnvilSmashingCategory;
import com.pigdad.paganbless.compat.jei.HerbalistBenchCategory;
import com.pigdad.paganbless.compat.jei.ImbuingCauldronCategory;
import com.pigdad.paganbless.compat.jei.RunicRitualCategory;
import com.pigdad.paganbless.content.blocks.BaseHangingHerbBlock;
import com.pigdad.paganbless.content.blocks.HangingHerbBlock;
import com.pigdad.paganbless.content.blocks.RuneSlabBlock;
import com.pigdad.paganbless.content.blocks.WaxedHangingHerbBlock;
import com.pigdad.paganbless.content.recipes.AnvilSmashingRecipe;
import com.pigdad.paganbless.content.recipes.BenchCuttingRecipe;
import com.pigdad.paganbless.content.recipes.ImbuingCauldronRecipe;
import com.pigdad.paganbless.content.recipes.RunicRitualRecipe;
import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.registries.PBItems;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class PBJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"paganbless", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ImbuingCauldronCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AnvilSmashingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RunicRitualCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new HerbalistBenchCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List<ImbuingCauldronRecipe> imbuingRecipe = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ImbuingCauldronRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(ImbuingCauldronCategory.RECIPE_TYPE, imbuingRecipe);
        List<AnvilSmashingRecipe> anvilSmashingRecipe = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AnvilSmashingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(AnvilSmashingCategory.RECIPE_TYPE, anvilSmashingRecipe);
        List<RunicRitualRecipe> runicRitualRecipe = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RunicRitualRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(RunicRitualCategory.RECIPE_TYPE, runicRitualRecipe);
        List<BenchCuttingRecipe> herbalistBenchRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)BenchCuttingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(HerbalistBenchCategory.RECIPE_TYPE, herbalistBenchRecipes);
        registration.addIngredientInfo(PBJeiPlugin.gatherHangingAndDriedHerbs(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei_info.paganbless.dried_herbs_info")});
        registration.addIngredientInfo(PBJeiPlugin.gatherHangingAndWaxedHerbs(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei_info.paganbless.waxed_herbs_info")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)Items.SKELETON_SKULL), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei_info.paganbless.skeleton_skull")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)PBItems.CINNABAR.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei_info.paganbless.cinnabar")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)PBItems.ESSENCE_OF_THE_FOREST.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei_info.paganbless.essence_of_the_forest")});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PBBlocks.HERBALIST_BENCH.get()), new RecipeType[]{HerbalistBenchCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PBBlocks.IMBUING_CAULDRON.get()), new RecipeType[]{ImbuingCauldronCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PBBlocks.RUNIC_CORE.get()), new RecipeType[]{RunicRitualCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.ANVIL), new RecipeType[]{AnvilSmashingCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PBBlocks.WINCH.get()), new RecipeType[]{AnvilSmashingCategory.RECIPE_TYPE});
        for (Item item : BuiltInRegistries.ITEM) {
            RuneSlabBlock runeSlabBlock;
            Block block = Block.byItem((Item)item);
            if (!(block instanceof RuneSlabBlock) || ((Object)((Object)(runeSlabBlock = (RuneSlabBlock)block))).equals(PBBlocks.RUNE_SLAB_INERT.get())) continue;
            registration.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{RunicRitualCategory.RECIPE_TYPE});
        }
    }

    private static List<ItemStack> gatherHangingAndDriedHerbs() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof BaseHangingHerbBlock && !(block instanceof WaxedHangingHerbBlock)).map(block -> block.asItem().getDefaultInstance()).toList();
    }

    private static List<ItemStack> gatherHangingAndWaxedHerbs() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof HangingHerbBlock || block instanceof WaxedHangingHerbBlock).map(block -> block.asItem().getDefaultInstance()).toList();
    }
}

