/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.compat.jei;

import com.pigdad.paganbless.content.blockentities.ImbuingCauldronBlockEntity;
import com.pigdad.paganbless.content.recipes.ImbuingCauldronRecipe;
import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.utils.recipes.RecipeUtils;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ImbuingCauldronCategory
implements IRecipeCategory<ImbuingCauldronRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"paganbless", (String)"cauldron_imbuing");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"paganbless", (String)"textures/gui/imbuing_cauldron.png");
    public static final RecipeType<ImbuingCauldronRecipe> RECIPE_TYPE = new RecipeType(UID, ImbuingCauldronRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public ImbuingCauldronCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)PBBlocks.IMBUING_CAULDRON.get()));
    }

    @NotNull
    public RecipeType<ImbuingCauldronRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Cauldron Imbuing");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ImbuingCauldronRecipe recipe, IFocusGroup focuses) {
        List<Vec2> coordinates = List.of(new Vec2(76.0f, 6.0f), new Vec2(119.0f, 20.0f), new Vec2(102.0f, 59.0f), new Vec2(49.0f, 59.0f), new Vec2(32.0f, 20.0f));
        float scale = 34.0f / (float)ImbuingCauldronBlockEntity.getCapacity();
        if (recipe.fluidIngredient().isPresent()) {
            int scaledAmount = (int)((float)recipe.fluidIngredient().get().amount() * scale);
            IRecipeSlotBuilder iRecipeSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 148, 34 + (34 - scaledAmount));
            for (FluidStack fluidStack : recipe.fluidIngredient().get().getFluids()) {
                iRecipeSlotBuilder.addFluidStack(fluidStack.getFluid(), (long)recipe.fluidIngredient().get().amount());
            }
            iRecipeSlotBuilder.setFluidRenderer((long)recipe.fluidIngredient().get().amount(), true, 16, scaledAmount);
        }
        for (int i = 0; i < 5; ++i) {
            try {
                Ingredient ingredient = RecipeUtils.iWCToIngredientsSaveCount(recipe.ingredients()).get(i);
                builder.addSlot(RecipeIngredientRole.INPUT, (int)coordinates.get((int)i).x, (int)coordinates.get((int)i).y).addIngredients(ingredient);
                continue;
            }
            catch (Exception ignored) {
                builder.addSlot(RecipeIngredientRole.INPUT, (int)coordinates.get((int)i).x, (int)coordinates.get((int)i).y).addIngredients(Ingredient.EMPTY);
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 38).addItemStack(recipe.getResultItem(null));
    }
}

