/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.api.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public abstract class LocationsSavedData
extends SavedData {
    protected Set<BlockPos> blocks;
    private int tickCounter;

    public LocationsSavedData() {
        this(new HashSet<BlockPos>());
    }

    public LocationsSavedData(Set<BlockPos> blocks) {
        this.blocks = blocks;
    }

    public abstract String getDataId();

    public void addBlockPos(BlockPos blockPos) {
        this.blocks.add(blockPos);
        this.setDirty();
    }

    public void removeBlockPos(BlockPos blockPos) {
        this.blocks.remove(blockPos);
        this.setDirty();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag blocksData = new CompoundTag();
        CompoundTag blocksTag = new CompoundTag();
        int i = 0;
        for (BlockPos pos : this.blocks) {
            blocksTag.putLong(String.valueOf(i), pos.asLong());
            ++i;
        }
        blocksData.put("blocks", (Tag)blocksTag);
        blocksData.putInt("blocks_amount", i);
        compoundTag.put(this.getDataId(), (Tag)blocksData);
        return compoundTag;
    }

    public static Set<BlockPos> load(CompoundTag nbt, String dataId, ServerLevel level) {
        CompoundTag wwData = nbt.getCompound(dataId);
        CompoundTag blocksTag = wwData.getCompound("blocks");
        int blocksAmount = wwData.getInt("blocks_amount");
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int i = 0; i < blocksAmount; ++i) {
            blocks.add(BlockPos.of((long)blocksTag.getLong(String.valueOf(i))));
        }
        return blocks;
    }

    public String toString() {
        return "LocationsSavedData{blocks=" + String.valueOf(this.blocks) + ", tickCounter=" + this.tickCounter + "}";
    }
}

