/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.registry;

import com.github.x3r.mekanism_turrets.common.block.ElectricFenceBlock;
import com.github.x3r.mekanism_turrets.common.block.LaserTurretBlock;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import com.github.x3r.mekanism_turrets.common.item.LaserTurretBlockItem;
import com.github.x3r.mekanism_turrets.common.registry.BlockTypeRegistry;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class BlockRegistry {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("mekanism_turrets");
    public static final BlockRegistryObject<ElectricFenceBlock, BlockItem> ELECTRIC_FENCE = BLOCKS.register("electric_fence", () -> new ElectricFenceBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL).noOcclusion()));
    public static final BlockRegistryObject<LaserTurretBlock, LaserTurretBlockItem> BASIC_LASER_TURRET = BlockRegistry.registerLaserTurret(BlockTypeRegistry.BASIC_LASER_TURRET);
    public static final BlockRegistryObject<LaserTurretBlock, LaserTurretBlockItem> ADVANCED_LASER_TURRET = BlockRegistry.registerLaserTurret(BlockTypeRegistry.ADVANCED_LASER_TURRET);
    public static final BlockRegistryObject<LaserTurretBlock, LaserTurretBlockItem> ELITE_LASER_TURRET = BlockRegistry.registerLaserTurret(BlockTypeRegistry.ELITE_LASER_TURRET);
    public static final BlockRegistryObject<LaserTurretBlock, LaserTurretBlockItem> ULTIMATE_LASER_TURRET = BlockRegistry.registerLaserTurret(BlockTypeRegistry.ULTIMATE_LASER_TURRET);

    private static BlockRegistryObject<LaserTurretBlock, LaserTurretBlockItem> registerLaserTurret(BlockTypeTile<LaserTurretBlockEntity> type) {
        return BlockRegistry.registerTieredBlock(type, "_laser_turret", () -> new LaserTurretBlock(type), LaserTurretBlockItem::new);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(BlockType type, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return BlockRegistry.registerTieredBlock(((AttributeTier)type.get(AttributeTier.class)).tier(), suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }
}

