/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.capability;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.UnknownNullability;

public class MTEnergyStorage
implements IEnergyStorage,
INBTSerializable<CompoundTag> {
    public static final String TAG_KEY = "EnergyStorage";
    private int maxReceive;
    private int maxExtract;
    private int maxEnergy;
    private int energy = 0;

    public MTEnergyStorage(int maxReceive, int maxExtract, int maxEnergy) {
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.maxEnergy = maxEnergy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int amount = Math.min(Math.min(this.maxReceive, maxReceive), this.getMaxEnergyStored() - this.getEnergyStored());
        if (!simulate) {
            this.energy += amount;
        }
        return amount;
    }

    public int forceReceiveEnergy(int maxReceive, boolean simulate) {
        int amount = Math.min(maxReceive, this.getMaxEnergyStored() - this.getEnergyStored());
        if (!simulate) {
            this.energy += amount;
        }
        return amount;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int amount = Math.min(Math.min(this.maxExtract, maxExtract), this.getEnergyStored());
        if (!simulate) {
            this.energy -= amount;
        }
        return amount;
    }

    public int forceExtractEnergy(int maxExtract, boolean simulate) {
        int amount = Math.min(maxExtract, this.getEnergyStored());
        if (!simulate) {
            this.energy -= amount;
        }
        return amount;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public void setEnergyStored(int energy) {
        this.energy = Math.min(this.getMaxEnergyStored(), energy);
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("MaxReceive", this.maxReceive);
        tag.putInt("MaxExtract", this.maxExtract);
        tag.putInt("MaxEnergy", this.maxEnergy);
        tag.putInt("Energy", this.energy);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        CompoundTag tag = nbt.getCompound(TAG_KEY);
        this.maxReceive = tag.getInt("MaxReceive");
        this.maxExtract = tag.getInt("MaxExtract");
        this.maxEnergy = tag.getInt("MaxEnergy");
        this.energy = tag.getInt("Energy");
    }
}

