/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.client.model;

import com.github.x3r.mekanism_turrets.common.block.LaserTurretBlock;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretTier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;

public class LaserTurretModel
extends DefaultedBlockGeoModel<LaserTurretBlockEntity> {
    private static final ResourceLocation MODEL_BASIC = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"geo/block/basic_laser_turret.geo.json");
    private static final ResourceLocation MODEL_ADVANCED = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"geo/block/advanced_laser_turret.geo.json");
    private static final ResourceLocation MODEL_ELITE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"geo/block/elite_laser_turret.geo.json");
    private static final ResourceLocation MODEL_ULTIMATE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"geo/block/ultimate_laser_turret.geo.json");
    private static final ResourceLocation TEXTURE_BASIC = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/block/basic_laser_turret.png");
    private static final ResourceLocation TEXTURE_ADVANCED = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/block/advanced_laser_turret.png");
    private static final ResourceLocation TEXTURE_ELITE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/block/elite_laser_turret.png");
    private static final ResourceLocation TEXTURE_ULTIMATE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/block/ultimate_laser_turret.png");
    private static final ResourceLocation ANIMATION_BASIC = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"animations/block/basic_laser_turret.animation.json");
    private static final ResourceLocation ANIMATION_ADVANCED = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"animations/block/advanced_laser_turret.animation.json");
    private static final ResourceLocation ANIMATION_ELITE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"animations/block/elite_laser_turret.animation.json");
    private static final ResourceLocation ANIMATION_ULTIMATE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"animations/block/ultimate_laser_turret.animation.json");

    public LaserTurretModel() {
        super(ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"laser_turret"));
    }

    public ResourceLocation getModelResource(LaserTurretBlockEntity animatable) {
        return switch (animatable.getTier()) {
            default -> throw new MatchException(null, null);
            case LaserTurretTier.BASIC -> MODEL_BASIC;
            case LaserTurretTier.ADVANCED -> MODEL_ADVANCED;
            case LaserTurretTier.ELITE -> MODEL_ELITE;
            case LaserTurretTier.ULTIMATE -> MODEL_ULTIMATE;
        };
    }

    public ResourceLocation getTextureResource(LaserTurretBlockEntity animatable) {
        return switch (animatable.getTier()) {
            default -> throw new MatchException(null, null);
            case LaserTurretTier.BASIC -> TEXTURE_BASIC;
            case LaserTurretTier.ADVANCED -> TEXTURE_ADVANCED;
            case LaserTurretTier.ELITE -> TEXTURE_ELITE;
            case LaserTurretTier.ULTIMATE -> TEXTURE_ULTIMATE;
        };
    }

    public ResourceLocation getAnimationResource(LaserTurretBlockEntity animatable) {
        return switch (animatable.getTier()) {
            default -> throw new MatchException(null, null);
            case LaserTurretTier.BASIC -> ANIMATION_BASIC;
            case LaserTurretTier.ADVANCED -> ANIMATION_ADVANCED;
            case LaserTurretTier.ELITE -> ANIMATION_ELITE;
            case LaserTurretTier.ULTIMATE -> ANIMATION_ULTIMATE;
        };
    }

    public void setCustomAnimations(LaserTurretBlockEntity animatable, long instanceId, AnimationState<LaserTurretBlockEntity> animationState) {
        GeoBone turret = this.getAnimationProcessor().getBone("turret");
        GeoBone cannon = this.getAnimationProcessor().getBone("cannon");
        if (turret != null && cannon != null) {
            if (this.hasTarget(animatable)) {
                Vec3 targetPos = new Vec3(this.targetX(animatable), this.targetY(animatable), this.targetZ(animatable));
                Direction direction = (Direction)animatable.getBlockState().getValue((Property)LaserTurretBlock.FACING);
                Vec3 center = animatable.getBlockPos().getCenter();
                Vector3f deltaPos = this.getTransform(direction).transform(new Vec3(targetPos.x - center.x, targetPos.y - center.y, targetPos.z - center.z).toVector3f());
                double deltaHorizontal = Math.sqrt(deltaPos.x * deltaPos.x + deltaPos.z * deltaPos.z);
                float xRot = this.lerp(animatable.xRot0, (float)(4.71238899230957 + Math.atan2(deltaPos.y, deltaHorizontal)));
                float yRot = this.lerp(animatable.yRot0, (float)(4.71238899230957 - Math.atan2(deltaPos.z, deltaPos.x)));
                animatable.xRot0 = xRot;
                animatable.yRot0 = yRot;
                cannon.setRotX(xRot);
                turret.setRotY(yRot);
            } else {
                float xRot = this.lerp(animatable.xRot0, -1.5707964f);
                float yRot = this.lerp(animatable.yRot0, 0.0f);
                animatable.xRot0 = xRot;
                animatable.yRot0 = yRot;
                cannon.setRotX(xRot);
                turret.setRotY(yRot);
            }
        }
    }

    private Quaternionf getTransform(Direction direction) {
        switch (direction) {
            case NORTH: {
                return new Quaternionf().rotationX(-1.5707964f);
            }
            case EAST: {
                return new Quaternionf().rotationZ(-1.5707964f);
            }
            case SOUTH: {
                return new Quaternionf().rotationX(1.5707964f);
            }
            case WEST: {
                return new Quaternionf().rotationZ(1.5707964f);
            }
            case UP: {
                return new Quaternionf().rotationZ((float)Math.PI);
            }
            case DOWN: {
                return new Quaternionf();
            }
        }
        return new Quaternionf();
    }

    private float lerp(float start, float end) {
        return Mth.rotLerp((float)0.1f, (float)(start * 57.295776f), (float)(end * 57.295776f)) * ((float)Math.PI / 180);
    }

    private boolean hasTarget(LaserTurretBlockEntity animatable) {
        return Boolean.TRUE.equals(animatable.getAnimData(LaserTurretBlockEntity.HAS_TARGET));
    }

    private double targetX(LaserTurretBlockEntity animatable) {
        Double targetX = (Double)animatable.getAnimData(LaserTurretBlockEntity.TARGET_POS_X);
        if (targetX != null) {
            return targetX;
        }
        return 0.0;
    }

    private double targetY(LaserTurretBlockEntity animatable) {
        Double targetY = (Double)animatable.getAnimData(LaserTurretBlockEntity.TARGET_POS_Y);
        if (targetY != null) {
            return targetY;
        }
        return 0.0;
    }

    private double targetZ(LaserTurretBlockEntity animatable) {
        Double targetZ = (Double)animatable.getAnimData(LaserTurretBlockEntity.TARGET_POS_Z);
        if (targetZ != null) {
            return targetZ;
        }
        return 0.0;
    }
}

