/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ResourceConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.SearchTerms;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.Nullable;

public class SelectImageResourceScreen
extends ResourceSelectorScreen<ResourceLocation> {
    private static final SelectableResource<ResourceLocation> NO_IMAGE = new SelectableResource.ImageResource(ImageResourceConfig.NONE);
    private static List<SelectableResource.ImageResource> cachedImages = null;
    public static final SearchModeIndex<ResourceSearchMode<ResourceLocation>> KNOWN_MODES = (SearchModeIndex)Util.make(new SearchModeIndex(), idx -> idx.appendMode(AllImagesMode.INSTANCE));

    public SelectImageResourceScreen(ResourceConfigValue<ResourceLocation> config, ConfigCallback callback) {
        super(config, callback);
    }

    private static void clearCachedImages() {
        cachedImages = null;
    }

    private static boolean isValidImage(ResourceLocation id) {
        return !id.getPath().startsWith("textures/font/");
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, @Nullable SelectableResource<ResourceLocation> resource) {
        return new ImageButton(this, panel, Objects.requireNonNullElse(resource, NO_IMAGE));
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<ResourceLocation>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    private class ImageButton
    extends ResourceSelectorScreen.ResourceButton {
        protected ImageButton(SelectImageResourceScreen selectImageResourceScreen, Panel panel, SelectableResource<ResourceLocation> resource) {
            super(panel, resource);
        }

        @Override
        public boolean shouldAdd(SearchTerms searchTerms) {
            return searchTerms.match((ResourceLocation)this.getStack(), ((ResourceLocation)this.getStack()).toString(), id -> false);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            MutableComponent text = Component.literal((String)((ResourceLocation)this.getStack()).getNamespace()).withStyle(ChatFormatting.GOLD).append(":").append((Component)Component.literal((String)((ResourceLocation)this.getStack()).getPath()).withStyle(ChatFormatting.YELLOW));
            list.add((Component)text);
            if (((Boolean)FTBLibraryClientConfig.IMAGE_MODNAME.get()).booleanValue()) {
                ModUtils.getModName(((ResourceLocation)this.getStack()).getNamespace()).ifPresent(name -> list.add((Component)Component.literal((String)name).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
            }
        }
    }

    private static enum AllImagesMode implements ResourceSearchMode<ResourceLocation>
    {
        INSTANCE;


        @Override
        public Icon getIcon() {
            return Icons.ART;
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.translatable((String)"ftblibrary.select_image.all_images");
        }

        @Override
        public Collection<? extends SelectableResource<ResourceLocation>> getAllResources() {
            if (cachedImages == null) {
                ArrayList images = new ArrayList();
                StringUtils.ignoreResourceLocationErrors = true;
                Map textures = Collections.emptyMap();
                try {
                    textures = Minecraft.getInstance().getResourceManager().listResources("textures", t -> t.getPath().endsWith(".png"));
                }
                catch (Exception ex) {
                    FTBLibrary.LOGGER.error("A mod has a broken resource preventing this list from loading: " + String.valueOf(ex));
                }
                StringUtils.ignoreResourceLocationErrors = false;
                textures.keySet().forEach(rl -> ResourceLocation.read((String)rl.toString()).result().ifPresentOrElse(images::add, () -> FTBLibrary.LOGGER.warn("Image {} has invalid path! Report this to author of '{}'!", rl, (Object)rl.getNamespace())));
                cachedImages = images.stream().sorted().map(res -> {
                    ResourceLocation res1 = ResourceLocation.fromNamespaceAndPath((String)res.getNamespace(), (String)res.getPath().substring(9, res.getPath().length() - 4));
                    TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(res1);
                    SpriteContents contents = sprite.contents();
                    if (contents.name().equals((Object)MissingTextureAtlasSprite.getLocation())) {
                        res1 = res;
                    }
                    return new SelectableResource.ImageResource(res1);
                }).toList();
            }
            return cachedImages;
        }
    }

    public static enum ResourceListener implements ResourceManagerReloadListener
    {
        INSTANCE;


        public void onResourceManagerReload(ResourceManager resourceManager) {
            SelectImageResourceScreen.clearCachedImages();
        }
    }
}

