/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T>
implements Comparable<ConfigValue<T>> {
    public static final Component NULL_TEXT = Component.literal((String)"null");
    public String id = "";
    protected T value;
    protected T defaultValue;
    private ConfigGroup group;
    private Consumer<T> setter;
    private int order = 0;
    private String nameKey = "";
    private Icon icon = Icons.SETTINGS;
    private boolean canEdit = true;

    protected static Component info(String key) {
        return Component.literal((String)(key + ":")).withStyle(ChatFormatting.AQUA);
    }

    public static Component info(String key, Object value) {
        Component c = value instanceof Component ? (Component)value : Component.literal((String)String.valueOf(value));
        return Component.literal((String)"").append((Component)Component.literal((String)(key + ": ")).withStyle(ChatFormatting.AQUA)).append(c);
    }

    public ConfigValue<T> init(ConfigGroup group, String id, @Nullable T value, Consumer<T> setter, @Nullable T defaultValue) {
        this.group = group;
        this.id = id;
        this.value = value == null ? null : this.copy(value);
        this.setter = setter;
        this.defaultValue = defaultValue;
        this.order = group.getValues().size();
        return this;
    }

    public final boolean setCurrentValue(@Nullable T v) {
        if (!this.isEqual(this.value, v)) {
            this.value = v;
            return true;
        }
        return false;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isEqual(@Nullable T v1, @Nullable T v2) {
        return Objects.equals(v1, v2);
    }

    public T copy(T value) {
        return value;
    }

    public final Color4I getColor() {
        return this.getColor(this.value);
    }

    public Color4I getColor(@Nullable T v) {
        return Color4I.GRAY;
    }

    public void addInfo(TooltipList list) {
        list.add(ConfigValue.info("Default", this.getStringForGUI(this.defaultValue)));
    }

    public abstract void onClicked(Widget var1, MouseButton var2, ConfigCallback var3);

    public final Component getStringForGUI() {
        return Component.literal((String)String.valueOf(this.value));
    }

    public Component getStringForGUI(@Nullable T v) {
        return Component.literal((String)String.valueOf(v));
    }

    public String getPath() {
        if (this.group == null) {
            return this.id;
        }
        String p = this.group.getPath();
        return p.isEmpty() ? this.id : p + "." + this.id;
    }

    public String getNameKey() {
        return this.nameKey.isEmpty() ? this.getPath() : this.nameKey;
    }

    public ConfigValue<T> setNameKey(String key) {
        this.nameKey = key;
        return this;
    }

    public String getName() {
        return I18n.get((String)this.getNameKey(), (Object[])new Object[0]);
    }

    public String getTooltip() {
        String k = this.getNameKey() + ".tooltip";
        return I18n.exists((String)k) ? I18n.get((String)k, (Object[])new Object[0]) : "";
    }

    public ConfigValue<T> setOrder(int o) {
        this.order = o;
        return this;
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public ConfigValue<T> setCanEdit(boolean e) {
        this.canEdit = e;
        return this;
    }

    public Icon getIcon() {
        return this.getIcon(this.getValue());
    }

    public ConfigValue<T> setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon(@Nullable T v) {
        return this.icon;
    }

    @Override
    public int compareTo(ConfigValue<T> o) {
        int i = this.group.compareTo(o.group);
        return i == 0 ? Integer.compare(this.order, o.order) : i;
    }

    public void applyValue() {
        this.setter.accept(this.value);
    }
}

