/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class StatueSavedData
extends SavedData {
    public static final StatueSavedData blank = new StatueSavedData();
    private static final String DATA_NAME = "statues_world_data";
    private static final Map<ResourceKey<Level>, List<BlockPos>> despawnerMap = new HashMap<ResourceKey<Level>, List<BlockPos>>();

    public BlockPos getNearestDespawner(ResourceKey<Level> dimension, BlockPos pos, int range) {
        if (despawnerMap.containsKey(dimension)) {
            List<BlockPos> posList = despawnerMap.get(dimension).stream().filter(storedPos -> storedPos.distManhattan((Vec3i)pos) <= range).toList();
            return !posList.isEmpty() ? posList.getFirst() : null;
        }
        return null;
    }

    public void addPosition(ResourceKey<Level> dimension, BlockPos pos) {
        List posList = despawnerMap.getOrDefault(dimension, new ArrayList());
        posList.add(pos);
        despawnerMap.put(dimension, posList);
        this.setDirty();
    }

    public void removePosition(ResourceKey<Level> dimension, BlockPos pos) {
        List posList = despawnerMap.getOrDefault(dimension, new ArrayList());
        posList.remove(pos);
        despawnerMap.put(dimension, posList);
        this.setDirty();
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        ListTag despawnerList = new ListTag();
        despawnerMap.forEach((dimension, posList) -> {
            CompoundTag tag = new CompoundTag();
            tag.putString("Dimension", dimension.location().toString());
            ListTag posListTag = new ListTag();
            for (BlockPos pos : posList) {
                CompoundTag tag1 = new CompoundTag();
                tag1.putLong("Pos", pos.asLong());
                posListTag.add((Object)tag1);
            }
            tag.put("Positions", (Tag)posListTag);
            despawnerList.add((Object)tag);
        });
        compound.put("DespawnerMap", (Tag)despawnerList);
        return compound;
    }

    public static StatueSavedData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        if (tag.contains("DespawnerMap")) {
            ListTag despawnerList = tag.getList("DespawnerMap", 10);
            despawnerList.forEach(t -> {
                CompoundTag despawnTag = (CompoundTag)t;
                String dimensionLocation = despawnTag.getString("Dimension");
                ArrayList posList = new ArrayList();
                ListTag posListTag = despawnTag.getList("Positions", 10);
                posListTag.forEach(t2 -> {
                    CompoundTag tag1 = (CompoundTag)t2;
                    BlockPos pos = BlockPos.of((long)tag1.getLong("Pos"));
                    posList.add(pos);
                });
                ResourceKey<Level> dimension = StatueSavedData.getLevelKey(dimensionLocation);
                despawnerMap.put(dimension, posList);
            });
        }
        return new StatueSavedData();
    }

    private static ResourceKey<Level> getLevelKey(String location) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)location));
    }

    public static StatueSavedData get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (StatueSavedData)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(StatueSavedData::new, StatueSavedData::load), DATA_NAME);
        }
        return blank;
    }
}

