/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.datacomponent.StatueUpgrades;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.registry.StatueDataComponents;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public enum UpgradeType implements StringRepresentable
{
    CRAFTING("crafting", false, false, 1),
    UPGRADE("upgrade", false, false, 1),
    GLOWING("glowing", true, false, 15),
    UNGLOWING("unglowing", false, false, 1),
    SPAWNER("spawner", true, true, 10),
    DESPAWNER("despawner", true, true, 1),
    MOB_KILLER("mob_killer", true, true, 3),
    LOOTING("looting", true, true, 5),
    AUTOMATION("automation", true, true, 1),
    SPEED("speed", true, true, 10),
    INTERACTION("interaction", true, true, 1),
    SOUND("sound", true, true, 1);

    public static final StringRepresentable.EnumCodec<UpgradeType> CODEC;
    private final String name;
    private final boolean upgraded;
    private final boolean subsequentUsesSlot;
    private final int cap;

    private UpgradeType(String name, boolean upgraded, boolean subsequentUsesSlot, int cap) {
        this.name = name;
        this.upgraded = upgraded;
        this.subsequentUsesSlot = subsequentUsesSlot;
        this.cap = cap;
    }

    public boolean isSubsequentUsesSlot() {
        return this.subsequentUsesSlot;
    }

    public boolean requiresUpgrade() {
        return this.upgraded;
    }

    public int getCap() {
        return this.cap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(ItemStack stack, int level) {
        if (this == CRAFTING) {
            return true;
        }
        if (this == UPGRADE) {
            if (stack.has(StatueDataComponents.UPGRADED)) return false;
            StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty());
            stack.set(StatueDataComponents.STATS, (Object)stats);
            stack.set(StatueDataComponents.UPGRADED, (Object)true);
            return true;
        }
        if (!(stack.getItem() instanceof StatueBlockItem)) return false;
        if (this.requiresUpgrade()) {
            if (!stack.has(StatueDataComponents.UPGRADED)) {
                return false;
            }
            if (!stack.has(StatueDataComponents.UPGRADED)) return false;
            StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty());
            int upgradeSlots = stats.upgradeSlots();
            if (this.isSubsequentUsesSlot() && upgradeSlots <= 0) {
                return false;
            }
            String ID = this.name().toLowerCase(Locale.ROOT);
            String glowingID = GLOWING.name().toLowerCase(Locale.ROOT);
            StatueUpgrades statueUpgrades = (StatueUpgrades)stack.getOrDefault(StatueDataComponents.UPGRADES, (Object)StatueUpgrades.empty());
            HashMap<String, Short> upgradeMap = new HashMap<String, Short>();
            short currentLevel = statueUpgrades.upgradeMap().getOrDefault(ID, (short)0);
            if (currentLevel + 1 > this.getCap()) return false;
            if (level != -1) {
                if (currentLevel != level) return false;
                if (this == GLOWING) {
                    upgradeMap.putAll(statueUpgrades.withUpgrade(glowingID));
                } else {
                    upgradeMap.putAll(statueUpgrades.withUpgrade(ID));
                }
                if (this.isSubsequentUsesSlot()) {
                    stats.setUpgradeSlots(--upgradeSlots);
                    stack.set(StatueDataComponents.STATS, (Object)stats);
                }
            } else {
                if (this == GLOWING) {
                    upgradeMap.putAll(statueUpgrades.withUpgrade(glowingID));
                } else {
                    upgradeMap.putAll(statueUpgrades.withUpgrade(ID));
                }
                if (this.isSubsequentUsesSlot()) {
                    stats.setUpgradeSlots(--upgradeSlots);
                    stack.set(StatueDataComponents.STATS, (Object)stats);
                }
            }
            stack.set(StatueDataComponents.UPGRADES, (Object)new StatueUpgrades(upgradeMap));
            return true;
        }
        if (this == UNGLOWING) {
            if (!stack.has(StatueDataComponents.UPGRADED)) {
                return false;
            }
            if (!stack.has(StatueDataComponents.UPGRADED)) return true;
            StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty());
            int upgradeSlots = stats.upgradeSlots();
            if (this.isSubsequentUsesSlot() && upgradeSlots <= 0) {
                return false;
            }
            String glowingID = GLOWING.name().toLowerCase(Locale.ROOT);
            StatueUpgrades statueUpgrades = (StatueUpgrades)stack.getOrDefault(StatueDataComponents.UPGRADES, (Object)StatueUpgrades.empty());
            short glowLevel = statueUpgrades.upgradeMap().getOrDefault(glowingID, (short)0);
            if (glowLevel <= 0) return false;
            HashMap<String, Short> upgradeMap = new HashMap<String, Short>(statueUpgrades.withDowngrade(glowingID));
            if (upgradeMap.getOrDefault(glowingID, (short)0) == 0) {
                upgradeMap.remove(glowingID);
            }
            stack.set(StatueDataComponents.UPGRADES, (Object)new StatueUpgrades(upgradeMap));
            return true;
        } else {
            stack.set(StatueDataComponents.UPGRADED, (Object)true);
        }
        return true;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(UpgradeType::values);
    }
}

