/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.shynieke.statues.recipe.StatuesRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class LootRecipe
implements Recipe<RecipeInput> {
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final ItemStack result2;
    protected final ItemStack result3;
    protected final float resultChance;
    protected final float result2Chance;
    protected final float result3Chance;
    protected final boolean showNotification;

    public LootRecipe(String group, Ingredient ingredient, ItemStack stack, float resultChance, ItemStack stack2, float result2Chance, ItemStack stack3, float result3Chance, boolean showNotification) {
        this.group = group;
        this.ingredient = ingredient;
        this.result = stack;
        this.resultChance = resultChance;
        this.result2 = stack2;
        this.result2Chance = result2Chance;
        this.result3 = stack3;
        this.result3Chance = result3Chance;
        this.showNotification = showNotification;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return ((Ingredient)this.getIngredients().getFirst()).test(recipeInput.getItem(0));
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider lookupProvider) {
        return this.getResultItem(lookupProvider).copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookupProvider) {
        return this.result;
    }

    public float getChance1() {
        return this.resultChance;
    }

    public ItemStack getResultItem2(HolderLookup.Provider lookupProvider) {
        return this.result2;
    }

    public float getChance2() {
        return this.result2Chance;
    }

    public ItemStack getResultItem3(RegistryAccess access) {
        return this.result3;
    }

    public float getChance3() {
        return this.result3Chance;
    }

    public RecipeSerializer<?> getSerializer() {
        return StatuesRecipes.LOOT_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return StatuesRecipes.LOOT_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<LootRecipe> {
        private static final MapCodec<LootRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.STRICT_CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(recipe -> recipe.result), (App)Codec.FLOAT.optionalFieldOf("result_chance", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.resultChance)), (App)ItemStack.STRICT_CODEC.optionalFieldOf("result2", (Object)ItemStack.EMPTY).forGetter(recipe -> recipe.result2), (App)Codec.FLOAT.optionalFieldOf("result_chance2", (Object)Float.valueOf(0.5f)).forGetter(recipe -> Float.valueOf(recipe.result2Chance)), (App)ItemStack.STRICT_CODEC.optionalFieldOf("result3", (Object)ItemStack.EMPTY).forGetter(recipe -> recipe.result3), (App)Codec.FLOAT.optionalFieldOf("result_chance3", (Object)Float.valueOf(0.1f)).forGetter(recipe -> Float.valueOf(recipe.result3Chance)), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, LootRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LootRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<LootRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LootRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static LootRecipe fromNetwork(RegistryFriendlyByteBuf byteBuf) {
            String s = byteBuf.readUtf(Short.MAX_VALUE);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)byteBuf);
            ItemStack result1 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)byteBuf);
            float chance1 = byteBuf.readFloat();
            ItemStack result2 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)byteBuf);
            float chance2 = byteBuf.readFloat();
            ItemStack result3 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)byteBuf);
            float chance3 = byteBuf.readFloat();
            boolean showNotification = byteBuf.readBoolean();
            return new LootRecipe(s, ingredient, result1, chance1, result2, chance2, result3, chance3, showNotification);
        }

        private static void toNetwork(RegistryFriendlyByteBuf byteBuf, LootRecipe recipe) {
            byteBuf.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.ingredient);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.result);
            byteBuf.writeFloat(recipe.resultChance);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.result2);
            byteBuf.writeFloat(recipe.result2Chance);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.result3);
            byteBuf.writeFloat(recipe.result3Chance);
            byteBuf.writeBoolean(recipe.showNotification);
        }
    }
}

