/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.network.handler;

import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.menu.StatueTableMenu;
import com.shynieke.statues.network.message.PlayerStatueSyncData;
import com.shynieke.statues.network.message.StatueTableData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSyncData(PlayerStatueSyncData syncData, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null) {
                ServerPlayer serverPlayer;
                ServerLevel serverLevel;
                Entity entity;
                CompoundTag data = syncData.tag();
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer && (entity = (serverLevel = (serverPlayer = (ServerPlayer)patt0$temp).serverLevel()).getEntity(syncData.playerUUID())) instanceof PlayerStatue) {
                    PlayerStatue playerStatue = (PlayerStatue)entity;
                    if (serverPlayer != null && (!playerStatue.isLocked() || playerStatue.getLockedBy().equals(serverPlayer.getUUID()))) {
                        CompoundTag entityTag = playerStatue.saveWithoutId(new CompoundTag());
                        CompoundTag entityTagCopy = entityTag.copy();
                        if (!data.isEmpty()) {
                            entityTagCopy.merge(data);
                            UUID uuid = playerStatue.getUUID();
                            playerStatue.load(entityTagCopy);
                            playerStatue.setUUID(uuid);
                        }
                        float YOffset = data.getFloat("yOffset");
                        playerStatue.setYOffset(YOffset);
                        String modelType = data.getString("Model");
                        playerStatue.setModel(modelType);
                        boolean lockFlag = data.getBoolean("Locked");
                        if (lockFlag) {
                            if (!playerStatue.isLocked()) {
                                playerStatue.setLockedBy(serverPlayer.getUUID());
                            }
                        } else if (playerStatue.isLocked()) {
                            playerStatue.setUnlocked();
                        }
                        ListTag tagList = data.getList("Move", 6);
                        double x = tagList.getDouble(0);
                        double y = tagList.getDouble(1);
                        double z = tagList.getDouble(2);
                        playerStatue.setPos(playerStatue.getX() + x, playerStatue.getY() + y, playerStatue.getZ() + z);
                        boolean noGravityFlag = data.getBoolean("NoGravity");
                        playerStatue.setNoGravity(noGravityFlag);
                    }
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"statues.networking.player_statue_sync.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleTableData(StatueTableData tableData, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null) {
                Player player = context.player();
                AbstractContainerMenu container = player.containerMenu;
                if (container instanceof StatueTableMenu) {
                    StatueTableMenu menu = (StatueTableMenu)container;
                    if (tableData.isButtonPressed()) {
                        menu.getStatueBE().executeCraft();
                    }
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"statues.networking.table.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

