/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.menu;

import com.shynieke.statues.blockentities.ShulkerStatueBlockEntity;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ShulkerStatueMenu
extends AbstractContainerMenu {
    private final ShulkerStatueBlockEntity shulkerBE;

    public ShulkerStatueMenu(int windowId, Inventory playerInventory, FriendlyByteBuf byteBuf) {
        this(windowId, playerInventory, ShulkerStatueMenu.getBlockEntity(playerInventory, byteBuf));
    }

    private static ShulkerStatueBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity BlockEntityAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (BlockEntityAtPos instanceof ShulkerStatueBlockEntity) {
            return (ShulkerStatueBlockEntity)BlockEntityAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(BlockEntityAtPos));
    }

    public ShulkerStatueMenu(int id, Inventory playerInventoryIn, ShulkerStatueBlockEntity shulkerBlockEntity) {
        super(StatueRegistry.SHULKER_STATUE_MENU.get(), id);
        int x;
        int y;
        this.shulkerBE = shulkerBlockEntity;
        Level level = playerInventoryIn.player.level();
        BlockPos pos = this.shulkerBE.getBlockPos();
        IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (handler == null) {
            throw new IllegalStateException("Item handler is null!");
        }
        int xPos = 8;
        int yPos = 18;
        int index = 0;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                int middle = x - 4;
                if (middle >= -1 && middle <= 1) continue;
                this.addSlot((Slot)new SlotItemHandler(handler, index++, xPos + x * 18, yPos + y * 18));
            }
        }
        yPos = 84;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.addSlot(new Slot((Container)playerInventoryIn, x2, xPos + x2 * 18, yPos + 58));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.shulkerBE.stillValid(playerIn) && !playerIn.isSpectator();
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int containerSize = 18;
            if (index < 18 ? !this.moveItemStackTo(itemstack1, 18, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 18, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        this.slotsChanged(null);
        return itemstack;
    }

    public ShulkerStatueBlockEntity getShulkerBE() {
        return this.shulkerBE;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }
}

