/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.CampfireStatueBlock;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class SpecialHandler {
    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack resultStack = event.getCrafting();
        if (resultStack.getItem() == ((PlayerStatueBlock)((Object)StatueRegistry.PLAYER_STATUE.get())).asItem()) {
            Player player = event.getEntity();
            if (player == null || player instanceof FakePlayer) {
                return;
            }
            player.hurt(player.damageSources().magic(), player.getMaxHealth() / 2.0f);
            resultStack.set(DataComponents.CUSTOM_NAME, (Object)player.getName());
        }
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            Level level = player.level();
            BlockPos pos = player.blockPosition();
            AABB aabb = new AABB((double)((float)pos.getX() - 0.5f), (double)((float)pos.getY() - 0.5f), (double)((float)pos.getZ() - 0.5f), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)).inflate(3.0);
            for (ItemEntity itemE : player.level().getEntitiesOfClass(ItemEntity.class, aabb)) {
                CampfireData data;
                boolean requirementsFound;
                boolean lavaFound;
                if (itemE == null || !itemE.getItem().getItem().equals(Items.DIAMOND)) continue;
                BlockPos lavaPos = itemE.blockPosition();
                if (level.getFluidState(itemE.blockPosition()).getType() == Fluids.LAVA) {
                    lavaFound = true;
                    lavaPos = itemE.blockPosition();
                } else if (level.getBlockState(itemE.blockPosition().below()).getBlock() == Blocks.LAVA) {
                    lavaFound = true;
                    lavaPos = itemE.blockPosition().below();
                } else {
                    lavaFound = false;
                }
                if (!(requirementsFound = (data = this.properStatuesFound(level, lavaPos.above(), (Block)StatueRegistry.PLAYER_STATUE.get(), (Block)StatueRegistry.CREEPER_STATUE.get())).getBool() != false && lavaFound)) continue;
                level.setBlockAndUpdate(lavaPos, Blocks.AIR.defaultBlockState());
                level.setBlockAndUpdate(data.getPos1(), Blocks.AIR.defaultBlockState());
                level.setBlockAndUpdate(data.getPos2(), Blocks.AIR.defaultBlockState());
                level.setBlockAndUpdate(lavaPos, (BlockState)((CampfireStatueBlock)((Object)StatueRegistry.CAMPFIRE_STATUE.get())).defaultBlockState().setValue((Property)AbstractStatueBase.INTERACTIVE, (Comparable)Boolean.valueOf(false)));
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)lavaPos.below().getX(), (double)lavaPos.below().getY(), (double)lavaPos.below().getZ(), 0.0, 0.0, 0.0);
                itemE.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public CampfireData properStatuesFound(Level level, BlockPos pos, Block block, Block block1) {
        CampfireData data = new CampfireData(false, pos, pos);
        BlockState northBlock = level.getBlockState(pos.relative(Direction.NORTH));
        BlockState eastBlock = level.getBlockState(pos.relative(Direction.EAST));
        BlockState southBlock = level.getBlockState(pos.relative(Direction.SOUTH));
        BlockState westBlock = level.getBlockState(pos.relative(Direction.WEST));
        if (this.isValidBlock(northBlock, block) && this.isValidBlock(southBlock, block1)) {
            data = new CampfireData(true, pos.relative(Direction.NORTH), pos.relative(Direction.SOUTH));
        } else if (this.isValidBlock(northBlock, block1) && this.isValidBlock(southBlock, block)) {
            data = new CampfireData(true, pos.relative(Direction.NORTH), pos.relative(Direction.SOUTH));
        } else if (this.isValidBlock(westBlock, block) && this.isValidBlock(eastBlock, block1)) {
            data = new CampfireData(true, pos.relative(Direction.WEST), pos.relative(Direction.EAST));
        } else if (this.isValidBlock(westBlock, block1) && this.isValidBlock(eastBlock, block)) {
            data = new CampfireData(true, pos.relative(Direction.WEST), pos.relative(Direction.EAST));
        }
        return data;
    }

    public boolean isValidBlock(BlockState state, Block block) {
        if (state.getBlock() == block && state.getBlock() instanceof AbstractStatueBase) {
            return (Boolean)state.getValue((Property)AbstractStatueBase.INTERACTIVE) == false;
        }
        return state.getBlock() instanceof PlayerStatueBlock;
    }

    public static class CampfireData {
        private final boolean bool;
        private final BlockPos pos1;
        private final BlockPos pos2;

        public CampfireData(boolean bool, BlockPos pos1, BlockPos pos2) {
            this.bool = bool;
            this.pos1 = pos1;
            this.pos2 = pos2;
        }

        public Boolean getBool() {
            return this.bool;
        }

        public BlockPos getPos1() {
            return this.pos1;
        }

        public BlockPos getPos2() {
            return this.pos2;
        }
    }
}

