/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;

public class FishHandler {
    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide) {
            ItemStack itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.EAGLE_RAY.get());
            this.dropFishedStatue(itemStackToDrop, (Entity)player, event);
        }
    }

    public void dropFishedStatue(ItemStack itemStackToDrop, Entity source, ItemFishedEvent event) {
        double random_drop = Math.random();
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayer)) break;
                ServerPlayer player = (ServerPlayer)source;
                if (source instanceof FakePlayer) break;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.getName().getString();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add((Object)itemStackToDrop);
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayer) || !(random_drop <= default_drop_chance)) break;
                event.getDrops().add((Object)itemStackToDrop);
                break;
            }
            case ALL: {
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add((Object)itemStackToDrop);
            }
        }
    }
}

