/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.server;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StatueLootProvider
extends LootTableProvider {
    public StatueLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(StatueBlocks::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(StatueEntities::new, LootContextParamSets.ENTITY)), lookupProvider);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        super.validate(writableregistry, validationcontext, problemreporter$collector);
    }

    private static class StatueEntities
    extends EntityLootSubProvider {
        protected StatueEntities(HolderLookup.Provider registries) {
            super(FeatureFlags.REGISTRY.allFlags(), registries);
        }

        public void generate() {
            this.add(StatueRegistry.PLAYER_STATUE_ENTITY.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)StatueRegistry.STATUE_CORE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)))).when(LootItemKilledByPlayerCondition.killedByPlayer())));
            this.add(StatueRegistry.STATUE_BAT.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)StatueRegistry.STATUE_CORE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).when(LootItemKilledByPlayerCondition.killedByPlayer())));
        }

        protected boolean canHaveLootTable(EntityType<?> entitytype) {
            return true;
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return StatueRegistry.ENTITIES.getEntries().stream().map(holder -> (EntityType)holder.get());
        }
    }

    private static class StatueBlocks
    extends BlockLootSubProvider {
        protected StatueBlocks(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected void generate() {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.add((Block)StatueRegistry.PEBBLE.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.1f, 0.14285715f, 0.25f, 1.0f}))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)))));
            this.dropSelf((Block)StatueRegistry.DISPLAY_STAND.get());
            this.dropSelf((Block)StatueRegistry.SOMBRERO.get());
            this.dropSelf((Block)StatueRegistry.BUMBO_STATUE.get());
            this.dropSelf((Block)StatueRegistry.EAGLE_RAY.get());
            this.dropSelf((Block)StatueRegistry.SLABFISH.get());
            this.dropSelf((Block)StatueRegistry.TROPIBEE.get());
            this.dropSelf((Block)StatueRegistry.AZZARO.get());
            this.dropSelf((Block)StatueRegistry.TOTEM_OF_UNDYING_STATUE.get());
            this.dropSelf((Block)StatueRegistry.INFO_STATUE.get());
            this.dropSelf((Block)StatueRegistry.STATUE_TABLE.get());
            this.dropSelf((Block)StatueRegistry.CORE_FLOWER.get());
            this.add((Block)StatueRegistry.CORE_FLOWER_CROP.get(), (LootTable.Builder)this.applyExplosionDecay((ItemLike)StatueRegistry.CORE_FLOWER_CROP, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)StatueRegistry.CORE_FLOWER_SEED.get()))))));
            this.add((Block)StatueRegistry.PLAYER_STATUE.get(), block -> LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.PROFILE).include(DataComponents.CUSTOM_NAME))))));
            for (DeferredHolder blockObject : StatueRegistry.BLOCKS.getEntries()) {
                if (!(blockObject.get() instanceof AbstractStatueBase)) continue;
                this.dropSelf((Block)blockObject.get());
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return StatueRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

