/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.server;

import com.shynieke.statues.registry.StatueRegistry;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class StatueAdvancementProvider
extends AdvancementProvider {
    public StatueAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new StatueAdvancementGenerator()));
    }

    public static class StatueAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(@NotNull HolderLookup.Provider registries, @NotNull Consumer<AdvancementHolder> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            AdvancementHolder root = Advancement.Builder.advancement().display(StatueAdvancementGenerator.rootDisplay((ItemLike)StatueRegistry.STATUE_CORE.get(), StatueAdvancementGenerator.advancementPrefix("root.title"), StatueAdvancementGenerator.advancementPrefix("root.desc"), StatueAdvancementGenerator.modLoc("textures/block/pebble.png"))).addCriterion("core", EnterBlockTrigger.TriggerInstance.entersBlock((Block)Blocks.AIR)).save(consumer, StatueAdvancementGenerator.rootID("root"));
            AdvancementHolder elderGuardian = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.ELDER_GUARDIAN_STATUE, AdvancementType.GOAL, false, root);
            StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.RAVAGER_STATUE, AdvancementType.GOAL, false, elderGuardian);
            AdvancementHolder zombie = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.ZOMBIE_STATUE, root);
            AdvancementHolder babyZombie = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.BABY_ZOMBIE_STATUE, zombie);
            AdvancementHolder flood = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.FLOOD_STATUE, AdvancementType.GOAL, true, babyZombie);
            AdvancementHolder husk = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.HUSK_STATUE, zombie);
            AdvancementHolder creeper = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.CREEPER_STATUE, husk);
            AdvancementHolder campfire = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.CAMPFIRE_STATUE, AdvancementType.CHALLENGE, true, creeper);
            AdvancementHolder drowned = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.DROWNED_STATUE, husk);
            AdvancementHolder guardian = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.GUARDIAN_STATUE, drowned);
            AdvancementHolder spider = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.SPIDER_STATUE, husk);
            AdvancementHolder slime = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.SLIME_STATUE, spider);
            AdvancementHolder statueTable = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.STATUE_TABLE, root);
            AdvancementHolder displayStand = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.DISPLAY_STAND, statueTable);
            AdvancementHolder infoStatue = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.INFO_STATUE, displayStand);
            AdvancementHolder bumbo = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.BUMBO_STATUE, infoStatue);
            AdvancementHolder enderman = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.ENDERMAN_STATUE, root);
            AdvancementHolder endermite = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.ENDERMITE_STATUE, enderman);
            AdvancementHolder shulker = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.SHULKER_STATUE, endermite);
            AdvancementHolder cod = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.COD_STATUE, root);
            AdvancementHolder salmon = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.SALMON_STATUE, cod);
            AdvancementHolder tropical = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.TROPICAL_FISH_B, AdvancementType.TASK, false, salmon, "tropical_fish_statue", AdvancementRequirements.Strategy.OR, StatueRegistry.TROPICAL_FISH_B, StatueRegistry.TROPICAL_FISH_BB, StatueRegistry.TROPICAL_FISH_BE, StatueRegistry.TROPICAL_FISH_BM, StatueRegistry.TROPICAL_FISH_BMB, StatueRegistry.TROPICAL_FISH_BMS, StatueRegistry.TROPICAL_FISH_E, StatueRegistry.TROPICAL_FISH_ES, StatueRegistry.TROPICAL_FISH_HB, StatueRegistry.TROPICAL_FISH_SB, StatueRegistry.TROPICAL_FISH_SD, StatueRegistry.TROPICAL_FISH_SS);
            AdvancementHolder tropicalAll = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.TROPICAL_FISH_BB, AdvancementType.GOAL, false, tropical, "tropical_fish_all_statue", AdvancementRequirements.Strategy.AND, StatueRegistry.TROPICAL_FISH_B, StatueRegistry.TROPICAL_FISH_BB, StatueRegistry.TROPICAL_FISH_BE, StatueRegistry.TROPICAL_FISH_BM, StatueRegistry.TROPICAL_FISH_BMB, StatueRegistry.TROPICAL_FISH_BMS, StatueRegistry.TROPICAL_FISH_E, StatueRegistry.TROPICAL_FISH_ES, StatueRegistry.TROPICAL_FISH_HB, StatueRegistry.TROPICAL_FISH_SB, StatueRegistry.TROPICAL_FISH_SD, StatueRegistry.TROPICAL_FISH_SS);
            AdvancementHolder axolotl = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.AXOLOTL_LUCY_STATUE, AdvancementType.TASK, false, salmon, "axolotl_statue", AdvancementRequirements.Strategy.OR, StatueRegistry.AXOLOTL_LUCY_STATUE, StatueRegistry.AXOLOTL_WILD_STATUE, StatueRegistry.AXOLOTL_GOLD_STATUE, StatueRegistry.AXOLOTL_CYAN_STATUE, StatueRegistry.AXOLOTL_BLUE_STATUE);
            AdvancementHolder axolotlAll = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.AXOLOTL_GOLD_STATUE, AdvancementType.GOAL, false, axolotl, "axolotl_all_statue", AdvancementRequirements.Strategy.AND, StatueRegistry.AXOLOTL_LUCY_STATUE, StatueRegistry.AXOLOTL_WILD_STATUE, StatueRegistry.AXOLOTL_GOLD_STATUE, StatueRegistry.AXOLOTL_CYAN_STATUE, StatueRegistry.AXOLOTL_BLUE_STATUE);
            AdvancementHolder pufferSmall = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.PUFFERFISH_SMALL_STATUE, salmon);
            AdvancementHolder pufferMedium = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.PUFFERFISH_MEDIUM_STATUE, pufferSmall);
            AdvancementHolder puffer = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.PUFFERFISH_STATUE, pufferMedium);
            AdvancementHolder dolphin = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.DOLPHIN_STATUE, salmon);
            AdvancementHolder squid = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.SQUID_STATUE, dolphin);
            AdvancementHolder turtle = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.TURTLE_STATUE, squid);
            AdvancementHolder witch = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.WITCH_STATUE, root);
            AdvancementHolder pillager = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.PILLAGER_STATUE, witch);
            AdvancementHolder vindicator = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.VINDICATOR_STATUE, pillager);
            StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.EVOKER_STATUE, vindicator);
            AdvancementHolder cow = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.COW_STATUE, root);
            AdvancementHolder mooshroom = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.MOOSHROOM_STATUE, cow);
            AdvancementHolder mooshroomBrown = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.BROWN_MOOSHROOM_STATUE, mooshroom);
            AdvancementHolder pig = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.PIG_STATUE, cow);
            AdvancementHolder snowman = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.SNOW_GOLEM_STATUE, cow);
            AdvancementHolder allay = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.ALLAY_STATUE, cow);
            AdvancementHolder wasteland = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.WASTELAND_STATUE, AdvancementType.CHALLENGE, true, pig);
            AdvancementHolder chicken = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.CHICKEN_STATUE, cow);
            AdvancementHolder kingCluck = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.KING_CLUCK_STATUE, AdvancementType.GOAL, true, chicken);
            AdvancementHolder chickenJockey = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.CHICKEN_JOCKEY_STATUE, chicken);
            AdvancementHolder sheep = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.SHEEP_STATUE_WHITE, AdvancementType.TASK, false, cow, "sheep_statue", AdvancementRequirements.Strategy.OR, StatueRegistry.SHEEP_SHAVEN_STATUE, StatueRegistry.SHEEP_STATUE_BLACK, StatueRegistry.SHEEP_STATUE_BLUE, StatueRegistry.SHEEP_STATUE_BROWN, StatueRegistry.SHEEP_STATUE_CYAN, StatueRegistry.SHEEP_STATUE_GRAY, StatueRegistry.SHEEP_STATUE_GREEN, StatueRegistry.SHEEP_STATUE_LIGHT_BLUE, StatueRegistry.SHEEP_STATUE_LIGHT_GRAY, StatueRegistry.SHEEP_STATUE_LIME, StatueRegistry.SHEEP_STATUE_MAGENTA, StatueRegistry.SHEEP_STATUE_ORANGE, StatueRegistry.SHEEP_STATUE_PINK, StatueRegistry.SHEEP_STATUE_PURPLE, StatueRegistry.SHEEP_STATUE_RED, StatueRegistry.SHEEP_STATUE_WHITE, StatueRegistry.SHEEP_STATUE_YELLOW);
            AdvancementHolder sheepAll = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.SHEEP_STATUE_WHITE, AdvancementType.GOAL, false, sheep, "sheep_all_statue", AdvancementRequirements.Strategy.AND, StatueRegistry.SHEEP_SHAVEN_STATUE, StatueRegistry.SHEEP_STATUE_BLACK, StatueRegistry.SHEEP_STATUE_BLUE, StatueRegistry.SHEEP_STATUE_BROWN, StatueRegistry.SHEEP_STATUE_CYAN, StatueRegistry.SHEEP_STATUE_GRAY, StatueRegistry.SHEEP_STATUE_GREEN, StatueRegistry.SHEEP_STATUE_LIGHT_BLUE, StatueRegistry.SHEEP_STATUE_LIGHT_GRAY, StatueRegistry.SHEEP_STATUE_LIME, StatueRegistry.SHEEP_STATUE_MAGENTA, StatueRegistry.SHEEP_STATUE_ORANGE, StatueRegistry.SHEEP_STATUE_PINK, StatueRegistry.SHEEP_STATUE_PURPLE, StatueRegistry.SHEEP_STATUE_RED, StatueRegistry.SHEEP_STATUE_WHITE, StatueRegistry.SHEEP_STATUE_YELLOW);
            AdvancementHolder cat = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.CAT_JELLIE_STATUE, AdvancementType.TASK, false, root, "cat_statue", AdvancementRequirements.Strategy.OR, StatueRegistry.CAT_BLACK_STATUE, StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE, StatueRegistry.CAT_CALICO_STATUE, StatueRegistry.CAT_JELLIE_STATUE, StatueRegistry.CAT_PERSIAN_STATUE, StatueRegistry.CAT_RAGDOLL_STATUE, StatueRegistry.CAT_RED_STATUE, StatueRegistry.CAT_SIAMESE_STATUE, StatueRegistry.CAT_TABBY_STATUE, StatueRegistry.CAT_TUXEDO_STATUE, StatueRegistry.CAT_WHITE_STATUE);
            AdvancementHolder catAll = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.CAT_TUXEDO_STATUE, AdvancementType.GOAL, false, cat, "cat_all_statue", AdvancementRequirements.Strategy.AND, StatueRegistry.CAT_BLACK_STATUE, StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE, StatueRegistry.CAT_CALICO_STATUE, StatueRegistry.CAT_JELLIE_STATUE, StatueRegistry.CAT_PERSIAN_STATUE, StatueRegistry.CAT_RAGDOLL_STATUE, StatueRegistry.CAT_RED_STATUE, StatueRegistry.CAT_SIAMESE_STATUE, StatueRegistry.CAT_TABBY_STATUE, StatueRegistry.CAT_TUXEDO_STATUE, StatueRegistry.CAT_WHITE_STATUE);
            AdvancementHolder fox = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.FOX_STATUE, cat);
            AdvancementHolder foxSnow = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.FOX_SNOW_STATUE, fox);
            AdvancementHolder panda = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.PANDA_LAZY_STATUE, AdvancementType.TASK, false, foxSnow, "panda_statue", AdvancementRequirements.Strategy.OR, StatueRegistry.PANDA_ANGRY_STATUE, StatueRegistry.PANDA_BROWN_STATUE, StatueRegistry.PANDA_LAZY_STATUE, StatueRegistry.PANDA_NORMAL_STATUE, StatueRegistry.PANDA_PLAYFUL_STATUE, StatueRegistry.PANDA_WEAK_STATUE, StatueRegistry.PANDA_WORRIED_STATUE);
            AdvancementHolder pandaAll = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.PANDA_BROWN_STATUE, AdvancementType.GOAL, false, panda, "panda_all_statue", AdvancementRequirements.Strategy.AND, StatueRegistry.PANDA_ANGRY_STATUE, StatueRegistry.PANDA_BROWN_STATUE, StatueRegistry.PANDA_LAZY_STATUE, StatueRegistry.PANDA_NORMAL_STATUE, StatueRegistry.PANDA_PLAYFUL_STATUE, StatueRegistry.PANDA_WEAK_STATUE, StatueRegistry.PANDA_WORRIED_STATUE);
            AdvancementHolder bee = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.BEE_STATUE, foxSnow);
            AdvancementHolder beeTrans = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.TRANS_BEE_STATUE, AdvancementType.GOAL, false, bee);
            AdvancementHolder beeAngry = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.ANGRY_BEE_STATUE, bee);
            AdvancementHolder rabbit = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.RABBIT_BR_STATUE, AdvancementType.TASK, false, foxSnow, "rabbit_statue", AdvancementRequirements.Strategy.OR, StatueRegistry.RABBIT_BR_STATUE, StatueRegistry.RABBIT_BS_STATUE, StatueRegistry.RABBIT_BW_STATUE, StatueRegistry.RABBIT_GO_STATUE, StatueRegistry.RABBIT_WH_STATUE, StatueRegistry.RABBIT_WS_STATUE);
            AdvancementHolder rabbitAll = StatueAdvancementGenerator.killerCollection(consumer, StatueRegistry.RABBIT_WH_STATUE, rabbit, "rabbit_all_statue", StatueRegistry.RABBIT_BR_STATUE, StatueRegistry.RABBIT_BS_STATUE, StatueRegistry.RABBIT_BW_STATUE, StatueRegistry.RABBIT_GO_STATUE, StatueRegistry.RABBIT_WH_STATUE, StatueRegistry.RABBIT_WS_STATUE);
            AdvancementHolder frog = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.FROG_TEMPERATE_STATUE, AdvancementType.TASK, false, root, "frog_statue", AdvancementRequirements.Strategy.OR, StatueRegistry.FROG_TEMPERATE_STATUE, StatueRegistry.FROG_WARM_STATUE, StatueRegistry.FROG_COLD_STATUE);
            AdvancementHolder frogAll = StatueAdvancementGenerator.onHoldAnyBlock(consumer, StatueRegistry.FROG_COLD_STATUE, AdvancementType.GOAL, false, frog, "frog_all_statue", AdvancementRequirements.Strategy.AND, StatueRegistry.FROG_TEMPERATE_STATUE, StatueRegistry.FROG_WARM_STATUE, StatueRegistry.FROG_COLD_STATUE);
            AdvancementHolder tadpole = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.TADPOLE_STATUE, frog);
            AdvancementHolder blaze = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.BLAZE_STATUE, root);
            AdvancementHolder ghast = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.GHAST_STATUE, blaze);
            AdvancementHolder magma = StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.MAGMA_STATUE, ghast);
            StatueAdvancementGenerator.onHoldBlock(consumer, StatueRegistry.PLAYER_STATUE, root);
        }

        protected static AdvancementHolder onHoldBlock(Consumer<AdvancementHolder> consumer, DeferredHolder<Block, ? extends Block> registryObject, AdvancementType type, boolean hidden, AdvancementHolder root) {
            String path = registryObject.getId().getPath();
            ResourceLocation registryLocation = StatueAdvancementGenerator.modLoc(path);
            DisplayInfo info = hidden ? StatueAdvancementGenerator.hiddenDisplay((ItemLike)registryObject.get(), path, type) : StatueAdvancementGenerator.simpleDisplay((ItemLike)registryObject.get(), path, type);
            return Advancement.Builder.advancement().display(info).parent(root).addCriterion(path, StatueAdvancementGenerator.onHeldItems((ItemLike)registryObject.get())).save(consumer, StatueAdvancementGenerator.rootID(registryLocation.getPath()));
        }

        protected static AdvancementHolder onHoldBlock(Consumer<AdvancementHolder> consumer, DeferredBlock<? extends Block> deferredHolder, AdvancementHolder root) {
            String path = deferredHolder.getId().getPath();
            ResourceLocation registryLocation = StatueAdvancementGenerator.modLoc(path);
            return Advancement.Builder.advancement().display(StatueAdvancementGenerator.simpleDisplay((ItemLike)deferredHolder.get(), path, AdvancementType.TASK)).parent(root).addCriterion(path, StatueAdvancementGenerator.onHeldItems((ItemLike)deferredHolder.get())).save(consumer, StatueAdvancementGenerator.rootID(registryLocation.getPath()));
        }

        @SafeVarargs
        protected static AdvancementHolder onHoldAnyBlock(Consumer<AdvancementHolder> consumer, DeferredBlock<? extends Block> deferredHolder, AdvancementType type, boolean hidden, AdvancementHolder root, String path, AdvancementRequirements.Strategy strategy, DeferredBlock<? extends Block> ... registryObjects) {
            ResourceLocation registryLocation = StatueAdvancementGenerator.modLoc(path);
            DisplayInfo info = hidden ? StatueAdvancementGenerator.hiddenDisplay((ItemLike)deferredHolder.get(), path, type) : StatueAdvancementGenerator.simpleDisplay((ItemLike)deferredHolder.get(), path, type);
            Advancement.Builder builder = Advancement.Builder.advancement().display(info).parent(root);
            for (DeferredBlock<? extends Block> registryObject : registryObjects) {
                builder.addCriterion(registryObject.getId().getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
            }
            return builder.requirements(strategy).save(consumer, StatueAdvancementGenerator.rootID(registryLocation.getPath()));
        }

        @SafeVarargs
        protected static AdvancementHolder killerCollection(Consumer<AdvancementHolder> consumer, DeferredBlock<? extends Block> displayObject, AdvancementHolder root, String path, DeferredBlock<? extends Block> ... deferredHolders) {
            ResourceLocation registryLocation = StatueAdvancementGenerator.modLoc(path);
            Advancement.Builder builder = Advancement.Builder.advancement().display(StatueAdvancementGenerator.simpleDisplay((ItemLike)displayObject.get(), path, AdvancementType.GOAL)).parent(root);
            for (DeferredBlock<? extends Block> registryObject : deferredHolders) {
                builder.addCriterion(registryObject.getId().getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)registryObject.get()}));
            }
            return builder.rewards(AdvancementRewards.Builder.function((ResourceLocation)StatueAdvancementGenerator.modLoc("killer_rabbit"))).requirements(AdvancementRequirements.Strategy.AND).save(consumer, StatueAdvancementGenerator.rootID(registryLocation.getPath()));
        }

        protected static AdvancementHolder onHoldItem(Consumer<AdvancementHolder> consumer, DeferredHolder<Item, ? extends Item> deferredHolder, AdvancementType type, boolean hidden, AdvancementHolder root) {
            String path = deferredHolder.getId().getPath();
            ResourceLocation registryLocation = StatueAdvancementGenerator.modLoc(path);
            DisplayInfo info = hidden ? StatueAdvancementGenerator.hiddenDisplay((ItemLike)deferredHolder.get(), path, type) : StatueAdvancementGenerator.simpleDisplay((ItemLike)deferredHolder.get(), path, type);
            return Advancement.Builder.advancement().display(info).parent(root).addCriterion(path, StatueAdvancementGenerator.onHeldItems((ItemLike)deferredHolder.get())).save(consumer, StatueAdvancementGenerator.rootID(registryLocation.getPath()));
        }

        protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
            return new DisplayInfo(new ItemStack(icon), (Component)Component.translatable((String)titleKey), (Component)Component.translatable((String)descKey), Optional.of(background), AdvancementType.TASK, false, false, false);
        }

        protected static DisplayInfo simpleDisplay(ItemLike icon, String name, AdvancementType type) {
            return new DisplayInfo(new ItemStack(icon), (Component)Component.translatable((String)StatueAdvancementGenerator.advancementPrefix(name + ".title")), (Component)Component.translatable((String)StatueAdvancementGenerator.advancementPrefix(name + ".desc")), Optional.empty(), type, true, true, false);
        }

        protected static DisplayInfo hiddenDisplay(ItemLike icon, String name, AdvancementType type) {
            return new DisplayInfo(new ItemStack(icon), (Component)Component.translatable((String)StatueAdvancementGenerator.advancementPrefix(name + ".title")), (Component)Component.translatable((String)StatueAdvancementGenerator.advancementPrefix(name + ".desc")), Optional.empty(), type, true, true, true);
        }

        protected static Criterion<KilledTrigger.TriggerInstance> onKill(EntityType<?> entityType) {
            return KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType));
        }

        protected static Criterion<InventoryChangeTrigger.TriggerInstance> onHeldItems(ItemLike ... items) {
            return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items);
        }

        private static ResourceLocation modLoc(String path) {
            return ResourceLocation.fromNamespaceAndPath((String)"statues", (String)path);
        }

        private static String advancementPrefix(String name) {
            return "advancement.statues." + name;
        }

        private static String rootID(String name) {
            return StatueAdvancementGenerator.modLoc(name).toString();
        }
    }
}

