/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.client;

import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.registry.StatueSounds;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public class StatueLanguageProvider
extends LanguageProvider {
    public StatueLanguageProvider(PackOutput packOutput) {
        super(packOutput, "statues", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.statues.blocks", "Statue Blocks");
        this.add("itemGroup.statues.items", "Statue Items");
        this.add("item.statues.statue_core.desc", "Alpha");
        this.addBlock((Supplier)StatueRegistry.STATUE_TABLE, "S.T.A.T.U.E");
        this.addBlock((Supplier)StatueRegistry.BABY_ZOMBIE_STATUE, "Baby Zombie Statue");
        this.addBlock((Supplier)StatueRegistry.ANGRY_BEE_STATUE, "Angry Bee Statue");
        this.addBlock((Supplier)StatueRegistry.BEE_STATUE, "Bee Statue");
        this.addBlock((Supplier)StatueRegistry.BLAZE_STATUE, "Blaze Statue");
        this.addBlock((Supplier)StatueRegistry.BUMBO_STATUE, "Bumbo Statue");
        this.addBlock((Supplier)StatueRegistry.CAMPFIRE_STATUE, "Campfire Statue");
        this.addBlock((Supplier)StatueRegistry.CHICKEN_JOCKEY_STATUE, "Chicken Jockey Statue");
        this.addBlock((Supplier)StatueRegistry.CHICKEN_STATUE, "Chicken Statue");
        this.addBlock((Supplier)StatueRegistry.COD_STATUE, "Cod Statue");
        this.addBlock((Supplier)StatueRegistry.COW_STATUE, "Cow Statue");
        this.addBlock((Supplier)StatueRegistry.CREEPER_STATUE, "Creeper Statue");
        this.addBlock((Supplier)StatueRegistry.DISPLAY_STAND, "Display Stand");
        this.addBlock((Supplier)StatueRegistry.DOLPHIN_STATUE, "Dolphin Statue");
        this.addBlock((Supplier)StatueRegistry.DROWNED_STATUE, "Drowned Statue");
        this.addBlock((Supplier)StatueRegistry.ENDERMAN_STATUE, "Enderman Statue");
        this.addBlock((Supplier)StatueRegistry.ENDERMITE_STATUE, "Endermite Statue");
        this.addBlock((Supplier)StatueRegistry.EVOKER_STATUE, "Evoker Statue");
        this.addBlock((Supplier)StatueRegistry.FLOOD_STATUE, "Flood Statue");
        this.addBlock((Supplier)StatueRegistry.GHAST_STATUE, "Ghast Statue");
        this.addBlock((Supplier)StatueRegistry.GUARDIAN_STATUE, "Guardian Statue");
        this.addBlock((Supplier)StatueRegistry.HUSK_STATUE, "Husk Statue");
        this.addBlock((Supplier)StatueRegistry.INFO_STATUE, "Informative Statue");
        this.addBlock((Supplier)StatueRegistry.KING_CLUCK_STATUE, "King Cluck Statue");
        this.addBlock((Supplier)StatueRegistry.MAGMA_STATUE, "Magma Cube Statue");
        this.addBlock((Supplier)StatueRegistry.MOOSHROOM_STATUE, "Mooshroom Statue");
        this.addBlock((Supplier)StatueRegistry.PEBBLE, "Pebble");
        this.addBlock((Supplier)StatueRegistry.PIG_STATUE, "Pig Statue");
        this.addBlock((Supplier)StatueRegistry.PLAYER_STATUE, "Player Statue");
        this.addBlock((Supplier)StatueRegistry.PUFFERFISH_MEDIUM_STATUE, "Slightly Bloated Pufferfish Statue");
        this.addBlock((Supplier)StatueRegistry.PUFFERFISH_SMALL_STATUE, "Small Pufferfish Statue");
        this.addBlock((Supplier)StatueRegistry.PUFFERFISH_STATUE, "Bloated Pufferfish Statue");
        this.addBlock((Supplier)StatueRegistry.RABBIT_BR_STATUE, "Rabbit Statue");
        this.addBlock((Supplier)StatueRegistry.RABBIT_BS_STATUE, "Rabbit Statue");
        this.addBlock((Supplier)StatueRegistry.RABBIT_BW_STATUE, "Rabbit Statue");
        this.addBlock((Supplier)StatueRegistry.RABBIT_GO_STATUE, "Rabbit Statue");
        this.addBlock((Supplier)StatueRegistry.RABBIT_WH_STATUE, "Rabbit Statue");
        this.addBlock((Supplier)StatueRegistry.RABBIT_WS_STATUE, "Rabbit Statue");
        this.addBlock((Supplier)StatueRegistry.SALMON_STATUE, "Salmon Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_SHAVEN_STATUE, "Shaven Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_BLACK, "Black Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_BLUE, "Blue Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_BROWN, "Brown Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_CYAN, "Cyan Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_GRAY, "Gray Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_GREEN, "Green Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_LIGHT_BLUE, "Light Blue Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_LIGHT_GRAY, "Light Gray Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_LIME, "Lime Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_MAGENTA, "Magenta Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_ORANGE, "Orange Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_PINK, "Pink Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_PURPLE, "Purple Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_RED, "Red Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_WHITE, "White Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHEEP_STATUE_YELLOW, "Yellow Sheep Statue");
        this.addBlock((Supplier)StatueRegistry.SHULKER_STATUE, "Shulker Statue");
        this.addBlock((Supplier)StatueRegistry.SLIME_STATUE, "Slime Statue");
        this.addBlock((Supplier)StatueRegistry.SNOW_GOLEM_STATUE, "Snow Man Statue");
        this.addBlock((Supplier)StatueRegistry.SOMBRERO, "Sombrero");
        this.addBlock((Supplier)StatueRegistry.SPIDER_STATUE, "Spider Statue");
        this.addBlock((Supplier)StatueRegistry.SQUID_STATUE, "Squid Statue");
        this.addBlock((Supplier)StatueRegistry.TOTEM_OF_UNDYING_STATUE, "Statue Of Undying");
        this.addBlock((Supplier)StatueRegistry.TRANS_BEE_STATUE, "Trans Bee Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_B, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_BB, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_BE, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_BM, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_BMB, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_BMS, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_E, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_ES, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_HB, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_SB, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_SD, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TROPICAL_FISH_SS, "Tropical Fish Statue");
        this.addBlock((Supplier)StatueRegistry.TURTLE_STATUE, "Turtle Statue");
        this.addBlock((Supplier)StatueRegistry.VILLAGER_BR_STATUE, "Villager Statue");
        this.addBlock((Supplier)StatueRegistry.VILLAGER_GR_STATUE, "Villager Statue");
        this.addBlock((Supplier)StatueRegistry.VILLAGER_PU_STATUE, "Villager Statue");
        this.addBlock((Supplier)StatueRegistry.VILLAGER_WH_STATUE, "Villager Statue");
        this.addBlock((Supplier)StatueRegistry.WASTELAND_STATUE, "Wasteland Pig Statue");
        this.addBlock((Supplier)StatueRegistry.WITCH_STATUE, "Witch Statue");
        this.addBlock((Supplier)StatueRegistry.ZOMBIE_STATUE, "Zombie Statue");
        this.addBlock((Supplier)StatueRegistry.ELDER_GUARDIAN_STATUE, "Elder Guardian Statue");
        this.addBlock((Supplier)StatueRegistry.RAVAGER_STATUE, "Ravager Statue");
        this.addBlock((Supplier)StatueRegistry.BROWN_MOOSHROOM_STATUE, "Brown Mooshroom Statue");
        this.addBlock((Supplier)StatueRegistry.VINDICATOR_STATUE, "Vindicator Statue");
        this.addBlock((Supplier)StatueRegistry.PILLAGER_STATUE, "Pillager Statue");
        this.addBlock((Supplier)StatueRegistry.FOX_STATUE, "Fox Statue");
        this.addBlock((Supplier)StatueRegistry.FOX_SNOW_STATUE, "Snow Fox Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_BLACK_STATUE, "Black Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE, "British Shorthair Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_CALICO_STATUE, "Calico Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_JELLIE_STATUE, "Jellie Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_PERSIAN_STATUE, "Persian Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_RAGDOLL_STATUE, "Ragdoll Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_RED_STATUE, "Red Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_SIAMESE_STATUE, "Siamese Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_TABBY_STATUE, "Tabby Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_TUXEDO_STATUE, "Tuxedo Cat Statue");
        this.addBlock((Supplier)StatueRegistry.CAT_WHITE_STATUE, "White Cat Statue");
        this.addBlock((Supplier)StatueRegistry.PANDA_ANGRY_STATUE, "Angry Panda Statue");
        this.addBlock((Supplier)StatueRegistry.PANDA_BROWN_STATUE, "Brown Panda Statue");
        this.addBlock((Supplier)StatueRegistry.PANDA_LAZY_STATUE, "Lazy Panda Statue");
        this.addBlock((Supplier)StatueRegistry.PANDA_NORMAL_STATUE, "Normal Panda Statue");
        this.addBlock((Supplier)StatueRegistry.PANDA_PLAYFUL_STATUE, "Playful Panda Statue");
        this.addBlock((Supplier)StatueRegistry.PANDA_WEAK_STATUE, "Weak Panda Statue");
        this.addBlock((Supplier)StatueRegistry.PANDA_WORRIED_STATUE, "Worried Panda Statue");
        this.addBlock((Supplier)StatueRegistry.DETECTIVE_PLATYPUS, "Detective Platypus Statue");
        this.addBlock((Supplier)StatueRegistry.TROPIBEE, "Tropibee Statue");
        this.addBlock((Supplier)StatueRegistry.EAGLE_RAY, "Eagle Ray Statue");
        this.addBlock((Supplier)StatueRegistry.SLABFISH, "Slabfish Statue");
        this.addBlock((Supplier)StatueRegistry.AZZARO, "Azzaro Statue");
        this.addBlock((Supplier)StatueRegistry.ALLAY_STATUE, "Allay Statue");
        this.addBlock((Supplier)StatueRegistry.AXOLOTL_LUCY_STATUE, "Axolotl Statue");
        this.addBlock((Supplier)StatueRegistry.AXOLOTL_WILD_STATUE, "Axolotl Statue");
        this.addBlock((Supplier)StatueRegistry.AXOLOTL_GOLD_STATUE, "Axolotl Statue");
        this.addBlock((Supplier)StatueRegistry.AXOLOTL_CYAN_STATUE, "Axolotl Statue");
        this.addBlock((Supplier)StatueRegistry.AXOLOTL_BLUE_STATUE, "Axolotl Statue");
        this.addBlock((Supplier)StatueRegistry.FROG_TEMPERATE_STATUE, "Frog Statue");
        this.addBlock((Supplier)StatueRegistry.FROG_WARM_STATUE, "Frog Statue");
        this.addBlock((Supplier)StatueRegistry.FROG_COLD_STATUE, "Frog Statue");
        this.addBlock((Supplier)StatueRegistry.TADPOLE_STATUE, "Tadpole Statue");
        this.addBlock((Supplier)StatueRegistry.WARDEN_STATUE, "Warden Statue");
        this.addBlock((Supplier)StatueRegistry.CORE_FLOWER, "Core Flower");
        this.addBlock((Supplier)StatueRegistry.CORE_FLOWER_CROP, "Core Flower");
        this.addItem((Supplier)StatueRegistry.NUGGET, "Royal Nugget");
        this.addItem((Supplier)StatueRegistry.SOUP, "Mooshroom Soup");
        this.addItem((Supplier)StatueRegistry.STATUE_CORE, "Statue Core");
        this.addItem((Supplier)StatueRegistry.TEA, "Cup Of Tea");
        this.addItem((Supplier)StatueRegistry.CUP, "Edible Cup");
        this.addItem((Supplier)StatueRegistry.MARSHMALLOW, "Marshmallow");
        this.addItem((Supplier)StatueRegistry.MARSHMALLOW_COOKED, "Cooked Marshmallow");
        this.addItem((Supplier)StatueRegistry.MARSHMALLOW_GOLDEN, "Golden Marshmallow");
        this.addItem((Supplier)StatueRegistry.MARSHMALLOW_CHARRED, "Charred Marshmallow");
        this.addItem((Supplier)StatueRegistry.PLAYER_COMPASS, "Player Compass");
        this.addItem((Supplier)StatueRegistry.PLAYER_STATUE_SPAWN_EGG, "Player Statue Spawn Egg");
        this.addItem((Supplier)StatueRegistry.STATUE_BAT_SPANW_EGG, "Statue Bat Spawn Egg");
        this.addItem((Supplier)StatueRegistry.CORE_ARMOR_TRIM_SMITHING_TEMPLATE, "Core Armor Trim Smithing Template");
        this.addItem((Supplier)StatueRegistry.CORE_FLOWER_SEED, "Core Flower Seed");
        this.addItem((Supplier)StatueRegistry.STATUE_CORE_POTTERY_SHERD, "Statue Core Pottery Sherd");
        this.add("trim_pattern.statues.core", "Statue Core");
        this.add("statues.cluckington.info", "Also known as Cluckington");
        this.add("statues.royalnugget.info", "Made for and from royals");
        this.add("statues.villager.info", "WIP, Trades in the future.");
        this.add("statues.tea.info", "Now with less milk.");
        this.add("statues.cup.info", "I can't believe its edible.");
        this.add("statues.last.known.location", "Tracking last known location of, %s");
        this.addEntityType(StatueRegistry.STATUE_BAT, "Statue Bat");
        this.addEntityType(StatueRegistry.PLAYER_STATUE_ENTITY, "Player Statue");
        this.add("statues.container.shulker_statue", "Shulker Statue");
        this.add("statues.container.statue_table", "S.T.A.T.U.E");
        this.add("statues.playerstatue.gui.title", "Player Statue");
        this.add("statues.playerstatue.gui.label.small", "Small");
        this.add("statues.playerstatue.gui.label.locked", "Locked");
        this.add("statues.playerstatue.gui.label.name_visible", "Name Visible");
        this.add("statues.playerstatue.gui.label.gravity", "Zero Gravity");
        this.add("statues.playerstatue.gui.label.y_offset", "Y Offset");
        this.add("statues.playerstatue.gui.label.rotation", "Rotation");
        this.add("statues.playerstatue.gui.label.head", "Head");
        this.add("statues.playerstatue.gui.label.body", "Body");
        this.add("statues.playerstatue.gui.label.left_leg", "Left Leg");
        this.add("statues.playerstatue.gui.label.right_leg", "Right Leg");
        this.add("statues.playerstatue.gui.label.left_arm", "Left Arm");
        this.add("statues.playerstatue.gui.label.right_arm", "Right Arm");
        this.add("statues.playerstatue.gui.label.copy", "Copy");
        this.add("statues.playerstatue.gui.label.paste", "Paste");
        this.add("statues.player.compass.dimension.failure", "%s is in another dimension.");
        this.add("statues.player.compass.offline", "%s can not be found, perhaps the player isn't online.");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.WASTELAND_HELLO, "Wasteland pig statue says hello");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.WASTELAND_ONWARDS, "Wasteland pig statue says to go onwards");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.WASTELAND_TEA, "Wasteland pig statue talks about tea");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.CAMPFIRE_HELLO, "Campfire statue says hello");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.CAMPFIRE_GREETINGS, "Campfire statue greets you");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.CAMPFIRE_BYE, "Campfire statue says bye");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.CAMPFIRE_SNACKS, "Campfire statue talks about snacks");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.CAMPFIRE_COLD, "Campfire statue talks about being cold");
        this.addSubtitle((Supplier<SoundEvent>)StatueSounds.CAMPFIRE_MARSHMALLOW, "Campfire statue talks about marshmallows");
        this.add("option.statues.player.name", "Player Statue Username?");
        this.add("option.statues.player.data", "Player Statue UUID?");
        this.add("option.statues.statue.timer", "Statue Timer Info?");
        this.add("tooltip.statues.player.info", "Player Username: ");
        this.add("tooltip.statues.player.info2", "Player UUID: ");
        this.add("tooltip.statues.timer", "Cooldown percentage: ");
        this.add("tooltip.statues.timer.finished", "Ready for interaction");
        this.add("gui.statue.loot", "Statue Loot");
        this.add("gui.statue.fill", "Filling Interactions");
        this.add("gui.statues.statue_table.chisel.tooltip", "Chisel");
        this.add("gui.statues.statue_table.invalid_recipe.tooltip", "Invalid Recipe");
        this.add("statues.networking.player_statue_screen.failed", "Failed to open Player Statue Screen: %s");
        this.add("statues.networking.player_statue_sync.failed", "Failed to sync Player Statue: %s");
        this.add("statues.networking.table.failed", "Failed to sync Statue Table: %s");
        this.add("curios.identifier.statue", "Statue");
        this.add("statues.gui.jei.category.loot", "Statue Loot");
        this.add("statues.gui.jei.category.upgrade", "Statue Upgrade");
        this.add("statues.gui.jei.statue.info", "%s can be obtained as a %s drop chance from killing %s");
        this.add("statues.gui.jei.statue_core.info", "%s can be obtained by killing %s");
        this.add("statues.gui.jei.statue_core.info2", "The %s just like the vanilla one can be found in dark areas but be careful!");
        this.add("statues.gui.jei.statue_table.info", "The Statue Upgrading System allows players to upgrade and level up their mob statues. This entry will provide an overview of how the system works and what upgrades are available.");
        this.add("statues.gui.jei.statue_table.info2", "To start upgrading a statue, players first need to obtain a statue of the desired mob.");
        this.add("statues.gui.jei.statue_table.info3", "Once the player has obtained a Statue and a Statue Core, they need to craft a \u00a7c\u00a7lS.T.A.T.U.E\u00a7r (\"Statue Table for Applying Tiered Upgrade Enhancements\") and insert the Statue Core and desired statue. After pressing the \"Chisel\" button, the statue will be upgraded to a state in which it can level up.");
        this.add("statues.gui.jei.statue_table.info4", "After upgrading the statue, players can level it up by killing 10 more of the corresponding mob while the statue is in their inventory. Every 10 mobs will unlock an upgrade slot up to a max of 16.");
        this.add("statues.gui.jei.statue_table.info5", "There are several different upgrades available for the statues:");
        this.add("statues.gui.jei.statue_table.info6", "\u00a7lGlowing\u00a7r - Allows the statue to emit light\n\u00a7lUnglowing\u00a7r - Removes previously applied glowing\n\u00a7lSpawner\u00a7r - Allows the statue to spawn it's mob every so often\n\u00a7lDespawner\u00a7r - Disallows it's mob from spawning in the nearby area");
        this.add("statues.gui.jei.statue_table.info7", "\u00a7lMob Killer\u00a7r - Kills the mob if it gets nearby (1 = Regular drops, 2 = Player drops, 3 = Player drops + XP)\n\u00a7lLooting\u00a7r - Allows the statue to generate loot\n\u00a7lAutomation\u00a7r - Allows exporting of loot\n\u00a7lSpeed\u00a7r - Speeds up the interaction/spawning timer");
        this.add("statues.gui.jei.statue_table.info8", "\u00a7lInteraction\u00a7r - Allows special interactions\n\u00a7lSound\u00a7r - Allows the statue to make sound when right-clicked or powered");
        this.add("statues.info.level", "Level:");
        this.add("statues.info.kills", "Kills:");
        this.add("statues.info.upgrade_slots", "Upgrade Slots:");
        this.add("statues.upgrade.upgrade_type", "Upgrade Type");
        this.add("statues.upgrade.upgrade.name", "Upgrade");
        this.add("statues.upgrade.glowing.name", "Glowing");
        this.add("statues.upgrade.unglowing.name", "Unglowing");
        this.add("statues.upgrade.spawner.name", "Spawner");
        this.add("statues.upgrade.despawner.name", "Despawner");
        this.add("statues.upgrade.mob_killer.name", "Mob Killer");
        this.add("statues.upgrade.looting.name", "Looting");
        this.add("statues.upgrade.automation.name", "Automation");
        this.add("statues.upgrade.speed.name", "Speed");
        this.add("statues.upgrade.interaction.name", "Interaction");
        this.add("statues.upgrade.sound.name", "Sound");
        this.add("fakeplayer.statue", "Statue");
        this.add("commands.statues.upgrade.too_high", "Chosen tier is invalid for this upgrade, the highest level is %s");
        this.add("commands.statues.upgrade.success", "%s has been upgraded");
        this.add("commands.statues.upgrade.invalid", "%s is not an upgradable statue");
        this.add("info.statues.book.name", "Statues");
        this.add("info.statues.book.subtitle", "Little useful mobs");
        this.add("info.statues.book.landing", "A book to help figure out what statues can do for you.");
        this.add("info.statues.book.info.name", "Information");
        this.add("info.statues.book.info.desc", "General info about Statues and it's features.");
        this.add("info.statues.book.upgrading.entry.name", "Upgrading");
        this.add("info.statues.book.upgrading.text1", "The Statue Upgrading System allows players to upgrade and level up their mob statues. This entry will provide an overview of how the system works and what upgrades are available.");
        this.add("info.statues.book.upgrading.text2", "To start upgrading a statue, players first need to obtain a statue of the desired mob. This can be done by killing the mob, with a 1%% chance of obtaining the statue by default (which can be changed in the config). In addition to the statue itself, players also need to obtain a $(l:info/core)Statue Core$().");
        this.add("info.statues.book.upgrading.text3", "Once the player has obtained a statue and a Statue Core, they need to craft a $(l:info/statue_table)S.T.A.T.U.E$() (\"Statue Table for Applying Tiered Upgrade Enhancements\") and insert the Statue Core and desired statue. After pressing the \"Chisel\" button, the statue will be upgraded to a state in which it can level up.");
        this.add("info.statues.book.upgrading.text4", "After upgrading the statue, players can level it up by killing 10 more of the corresponding mob while the statue is in their inventory. Every 10 mobs will unlock an upgrade slot up to a max of 16.");
        this.add("info.statues.book.upgrading.text5", "There are several different upgrades available for the statues:$(br)$(l)Glowing$() - Allows the statue to emit light$(br)$(l)Unglowing$() - Removes previously applied glowing$(br)$(l)Spawner$() - Allows the statue to spawn it's mob every so often$(br)$(l)Despawner$() - Disallows it's mob from spawning in the nearby area");
        this.add("info.statues.book.upgrading.text6", "$(l)Mob Killer$() - Kills the mob if it gets nearby (1 = Regular drops, 2 = Player drops, 3 = Player drops + XP)$(br)$(l)Looting$() - Allows the statue to generate loot$(br)$(l)Automation$() - Allows exporting of loot$(br)$(l)Speed$() - Speeds up the interaction/spawning timer");
        this.add("info.statues.book.upgrading.text7", "$(l)Interaction$() - Allows special interactions$(br)$(l)Sound$() - Allows the statue to make sound when right-clicked or powered");
        this.add("info.statues.book.core.entry.name", "Statue Core");
        this.add("info.statues.book.core.text1", "Statue Core's are dropped by the Statue Bat.$(br)The Statue bat just like the vanilla one can be found in dark areas but beware! It hurts you back if you try to kill it.");
        this.add("info.statues.book.statue_table.entry.name", "S.T.A.T.U.E.");
        this.add("info.statues.book.statue_table.text1", "The S.T.A.T.U.E. or Statue Table for Applying Tiered Upgrade Enhancements is a worktable that can be used to upgrade Statues.");
        this.add("statues.modeltype.AUTO", "Auto");
        this.add("statues.modeltype.DEFAULT", "Default");
        this.add("statues.modeltype.SLIM", "Slim");
        this.add("statues.playerstatue.gui.label.model_type", "Model Type");
        this.add("statues.playerstatue.gui.label.position", "Position");
        this.addAdvancement("root", "Statues", "Killing a mob may sometimes drop a smaller one");
        this.addAdvancement("player_statue", "A statue of a friend or foe", "Obtain a Player Statue by having to respawn thanks to a player");
        this.addAdvancement("elder_guardian_statue", "Slaying the elders of the monuments", "Obtain a Elder Guardian Statue");
        this.addAdvancement("ravager_statue", "Ravaging through the statues", "Obtain a Ravager Statue");
        this.addAdvancement("zombie_statue", "Just wants to nibble on your brains", "Obtain a Zombie Statue");
        this.addAdvancement("baby_zombie_statue", "Baby undead", "Obtain a Baby Zombie Statue");
        this.addAdvancement("flood_statue", "Let the flood happen", "You found the way to create Docm77's secret statue");
        this.addAdvancement("husk_statue", "Letting a zombie dry up in the sun... would be funny if that worked", "Obtain a Husk Statue");
        this.addAdvancement("creeper_statue", "It won't blow up this time", "Obtain a Creeper Statue");
        this.addAdvancement("spider_statue", "BURN IT WITH FIRE!", "Obtain a Spider Statue");
        this.addAdvancement("slime_statue", "You found a Slime chunk!", "Obtain a Slime Statue");
        this.addAdvancement("drowned_statue", "Drowning a zombie statue does not work", "Obtain a Drowned Statue");
        this.addAdvancement("guardian_statue", "Slaying the protectors of the ocean", "Obtain a Guardian Statue");
        this.addAdvancement("campfire_statue", "Created blue fire, the old fashioned way", "Obtain Etho's secret statue");
        this.addAdvancement("pig_statue", "You pigged up a Statue", "Obtain a Pig Statue");
        this.addAdvancement("wasteland_statue", "Riding the pigs!", "You found Xisuma's secret statue");
        this.addAdvancement("statue_table", "S.T.A.T.U.E", "Wait you can upgrade statues?!");
        this.addAdvancement("display_stand", "A fancy way to display statues and more!", "You cut the Nether Quartz in just the right pieces");
        this.addAdvancement("info_statue", "Question about Statues? just right click me", "Crafted an Informative Statue");
        this.addAdvancement("bumbo_statue", "Bumbo's legacy", "Put a hat on a cactus");
        this.addAdvancement("witch_statue", "Bewitched!", "Obtain a Witch Statue");
        this.addAdvancement("pillager_statue", "Crossbow Included", "Obtain a Pillager Statue");
        this.addAdvancement("vindicator_statue", "Can I axe you a question", "Obtain a Vindicator Statue");
        this.addAdvancement("evoker_statue", "Wooolooolooo", "Obtain an Evoker Statue");
        this.addAdvancement("enderman_statue", "It won't teleport around... or at least it should not", "Obtain an Enderman Statue");
        this.addAdvancement("endermite_statue", "That pearl was in fact infected", "Obtain an Endermite Statue");
        this.addAdvancement("shulker_statue", "Relocating the City citizen", "Obtain a Shulker Statue");
        this.addAdvancement("cod_statue", "There are more fish in the sea", "Obtain a Cod Statue");
        this.addAdvancement("dolphin_statue", "A playful friend", "Obtain a Dolhpin Statue");
        this.addAdvancement("pufferfish_small_statue", "It is so Smoll protect it all cost!", "Obtain the smallest Pufferfish Statue");
        this.addAdvancement("pufferfish_medium_statue", "Don't scare it", "Obtain a slightly bloated Pufferfish Statue");
        this.addAdvancement("pufferfish_statue", "You scared it!", "Obtain a bloated Pufferfish Statue");
        this.addAdvancement("salmon_statue", "Going upstream!", "Obtain a Salmon Statue");
        this.addAdvancement("squid_statue", "Release the kraken!", "Obtain a Squid Statue");
        this.addAdvancement("turtle_statue", "Does it live in a sewer?", "Obtain a Turtle Statue");
        this.addAdvancement("tropical_fish_statue", "Tropical Fish statue", "Obtain any Tropical Fish Statue");
        this.addAdvancement("tropical_fish_all_statue", "Extinction of the Coral Reef", "Obtain all Tropical Fish Statue");
        this.addAdvancement("cow_statue", "This one is amoozing", "Obtain a Cow Statue");
        this.addAdvancement("mooshroom_statue", "Poisonous cows?", "Obtain a Red Mooshroom Statue");
        this.addAdvancement("brown_mooshroom_statue", "Fungi Cows?", "Obtain a Brown Mooshroom Statue");
        this.addAdvancement("sheep_statue", "Sheep Statue", "Obtain any Sheep Statue");
        this.addAdvancement("sheep_all_statue", "Herding Sheep", "Obtain all Sheep Statue");
        this.addAdvancement("snow_golem_statue", "Do you want to kill a Snow Man", "Obtain a Snow Man Statue");
        this.addAdvancement("chicken_statue", "Clearly the chicken came first, there is no egg statue", "Obtain a Chicken Statue");
        this.addAdvancement("king_cluck_statue", "A royal chicken, who would have thought", "You managed to make a chicken royal!");
        this.addAdvancement("chicken_jockey_statue", "Zombie loves chicken", "You successfully created a Chicken Jockey");
        this.addAdvancement("cat_statue", "A purrfect catch", "Collect any Cat Statue");
        this.addAdvancement("cat_all_statue", "Catastrophic collection", "Collect all Cat Statues");
        this.addAdvancement("rabbit_statue", "Rabbit statue", "Collect any Rabbit Statue");
        this.addAdvancement("rabbit_all_statue", "Just Caerbannog missing", "Collect all Rabbit Statues");
        this.addAdvancement("panda_statue", "Nanananana pandaaaaa", "Collect any Panda Statue");
        this.addAdvancement("panda_all_statue", "Extinction of the bamboo", "Collect all Panda Statues");
        this.addAdvancement("fox_statue", "Burning it would make it a firefox right?", "Obtain a Fox Statue");
        this.addAdvancement("fox_snow_statue", "Snow fox given", "Obtain a Snow Fox Statue");
        this.addAdvancement("bee_statue", "What is all the buzz about", "Obtain a Bee Statue");
        this.addAdvancement("trans_bee_statue", "Just bee you!", "TRANS RIGHTS ARE HUMAN RIGHTS!");
        this.addAdvancement("angry_bee_statue", "This one must sting!", "Obtain an Angry Bee Statue");
        this.addAdvancement("blaze_statue", "Retrieved from fire", "Obtain a Blaze Statue");
        this.addAdvancement("ghast_statue", "The squids from the nether", "Obtain a Ghast Statue");
        this.addAdvancement("magma_statue", "Boiled Slimes", "Obtain a Magma Cube Statue");
        this.addAdvancement("allay_statue", "Your Allay", "Obtain an allay Statue");
        this.addAdvancement("axolotl_statue", "Water kitten", "Collect any Axolotl Statue");
        this.addAdvancement("axolotl_all_statue", "Critically endangered", "Collect all Axolotl Statues");
        this.addAdvancement("frog_statue", "Ribbiting experience", "Collect any Frog Statue");
        this.addAdvancement("frog_all_statue", "Combining our powers for reals", "Collect all Frog Statues");
        this.addAdvancement("tadpole_statue", "Frogn't", "Obtain a Tadpole Statue");
        this.addAdvancement("warden_statue", "You've been Awardend", "Obtain a Warden Statue");
        this.addConfig("general.title", "General", null);
        this.addConfig("statueBatSpawning", "Statue Bat Spawning", "Setting this to false disables the statue bat from spawning naturally (Default: true)");
        this.addConfig("ancientCityLoot", "Ancient City Loot", "When enabled this will allow Ancient City loot to contain statues (Default: true)");
        this.addConfig("ancientCityLootChance", "Ancient City Loot Chance", "The chance of a statue appearing in ancient City loot (Default: 0.1)");
        this.addConfig("statueCooldown", "Statue Cooldown", "The amount of ticks before an upgraded statue becomes interact-able (Default: 200)");
        this.addConfig("statueMinCooldown", "Statue Min Cooldown", "The minimum cooldown in ticks a statue can have after the speed has been subtracted (Default: 10)");
        this.addConfig("statueSpeedUpgrade", "Statue Speed Upgrade", "The amount of ticks subtracted from the statue cooldown per level of Speed applied (Default: 20)");
        this.addConfig("drops.title", "Drops", null);
        this.addConfig("statueDropChance", "Statue Drop Chance", "The drop chance of statues when statue drops is true (Default: 0.01)");
        this.addConfig("statueKillSource", "Statue Kill Source", "Source of death that determines how the Statues drop (Default: \"PLAYER\") [player statue has it's own config option],\nALL = All sources,\nPLAYER = Player only,\nPLAYER_FAKEPLAYER = Players / Fake players only");
        this.addConfig("player.title", "Player", null);
        this.addConfig("playerDropsStatue", "Player Drops Statue", "When true players will drop Player Statues when killed (Default: true)");
        this.addConfig("playerDropsKillSource", "Player Drops Kill Source", "Source of death that determines how the Player Statue drops (Default: \"PLAYER\") [player statue has it's own config option],\n ALL = All sources,\n PLAYER = Player only,\n PLAYER_FAKEPLAYER = Players / Fake players only");
        this.addConfig("playerStatueDropChance", "Player Statue Drop Chance", "The drop chance of player statues when playerDropsStatue is enabled (Default: 1.0)");
        this.addConfig("playerCompass", "Player Compass", "When true Statues will add a player compass (Default: true)");
        this.addConfig("info_messages.title", "Info Messages", null);
        this.addConfig("info_messages", "Info Messages", "Adding lines / removing lines specifies what the informative statue can say");
        this.addConfig("power_settings.title", "Power Settings", null);
        this.addConfig("requiresPower", "Requires Power", "When true statues will require power to function when upgraded (Default: false)");
        this.addConfig("powerDrain", "Power Drain", "If statues should drain power over time (Default: true)");
        this.addConfig("itemPowerUsage", "Item Power Usage", "The power used to generate an item (200)");
        this.addConfig("killPowerUsage", "Kill Power Usage", "The power used to kill a mob (500)");
        this.addConfig("summonPowerUsage", "Summon Power Usage", "The power used to summon a mob (500)");
        this.addConfig("despawnPowerUsage", "Despawn Power Usage", "The power used to despawn a mob (250)");
        this.addConfig("lucky_players.title", "Lucky Players", null);
        this.addConfig("lucky_players", "Lucky Players", "Adding usernames will make these users have less luck with getting statues");
        this.addConfig("client.title", "Client", null);
        this.addConfig("allowScrolling", "Allow Scrolling", "Allow scrolling to increase / decrease an angle value in the posing screen");
        this.add("config.jade.plugin_statues.upgrades", "Statue Upgrades");
    }

    public void addSubtitle(Supplier<SoundEvent> sound, String text) {
        this.addSubtitle(sound.get(), text);
    }

    public void addSubtitle(SoundEvent sound, String text) {
        String path = "statues.subtitle." + sound.getLocation().getPath();
        this.add(path, text);
    }

    private void addAdvancement(String id, String name, String description) {
        String prefix = "advancement.statues.";
        this.add(prefix + id + ".title", name);
        this.add(prefix + id + ".desc", description);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("statues.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("statues.configuration." + path + ".tooltip", description);
        }
    }
}

