/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.rei.display;

import com.shynieke.statues.compat.rei.REIPlugin;
import com.shynieke.statues.recipe.UpgradeType;
import com.shynieke.statues.registry.StatueTags;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class UpgradeDisplay
implements Display {
    private final boolean requireCore;
    private final UpgradeType upgradeType;
    private final int tier;
    private final List<EntryIngredient> inputEntries;
    private final List<EntryIngredient> outputEntries;
    private final EntryIngredient centerEntry;
    private final List<EntryIngredient> catalystsEntries;
    private final EntryIngredient resultEntry;
    private final EntryIngredient coreEntry;

    public UpgradeDisplay(List<ItemStack> centerStacks, NonNullList<Ingredient> catalysts, List<ItemStack> stacks, boolean requireCore, UpgradeType upgradeType, int tier) {
        this.requireCore = requireCore;
        this.upgradeType = upgradeType;
        this.tier = tier;
        this.inputEntries = new ArrayList<EntryIngredient>();
        this.inputEntries.add(EntryIngredients.ofItemStacks(centerStacks));
        if (requireCore) {
            this.inputEntries.add(EntryIngredients.ofIngredient((Ingredient)Ingredient.of(StatueTags.STATUE_CORE)));
        }
        this.inputEntries.addAll(EntryIngredients.ofIngredients(catalysts));
        this.outputEntries = List.of(EntryIngredients.ofItemStacks(stacks));
        this.centerEntry = EntryIngredients.ofItemStacks(centerStacks);
        this.catalystsEntries = EntryIngredients.ofIngredients(catalysts);
        this.resultEntry = EntryIngredients.ofItemStacks(stacks);
        this.coreEntry = EntryIngredients.ofIngredient((Ingredient)Ingredient.of(StatueTags.STATUE_CORE));
    }

    public EntryIngredient getCenter() {
        return this.centerEntry;
    }

    public List<EntryIngredient> getCatalysts() {
        return this.catalystsEntries;
    }

    public EntryIngredient getResult() {
        return this.resultEntry;
    }

    public boolean isRequireCore() {
        return this.requireCore;
    }

    public EntryIngredient getCore() {
        return this.coreEntry;
    }

    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public int getTier() {
        return this.tier;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REIPlugin.UPGRADE;
    }
}

