/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.rei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.shynieke.statues.compat.rei.REIPlugin;
import com.shynieke.statues.compat.rei.display.LootDisplay;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;

public class LootCategory
implements DisplayCategory<LootDisplay> {
    public CategoryIdentifier<? extends LootDisplay> getCategoryIdentifier() {
        return REIPlugin.LOOT;
    }

    public Component getTitle() {
        return Component.translatable((String)"statues.gui.jei.category.loot");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)StatueRegistry.STATUE_TABLE.get()));
    }

    public List<Widget> setupDisplay(LootDisplay display, Rectangle bounds) {
        Point centerPoint = new Point(bounds.getCenterX(), bounds.getCenterY());
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(centerPoint.x - 20, centerPoint.y - 7)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getMinX() + 8, centerPoint.y - 7)).entries((Collection)display.getInputEntries().getFirst()).markInput());
        if (display.getOutputEntries().size() != 3) {
            throw new IndexOutOfBoundsException("A Loot Recipe must have 3 outputs!, found " + display.getOutputEntries().size() + " outputs!. Please report this to the mod author!");
        }
        widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x + 8, bounds.getMinY() + 5)).entries((Collection)display.getOutputEntries().get(0)).markOutput());
        widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x + 8, bounds.getMinY() + 24)).entries((Collection)display.getOutputEntries().get(1)).markOutput());
        widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x + 8, bounds.getMinY() + 43)).entries((Collection)display.getOutputEntries().get(2)).markOutput());
        widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, v) -> {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, (Component)Component.literal((String)((int)(100.0f * display.getChance1()) + "%")), 74, 8, 0, false);
            guiGraphics.drawString(font, (Component)Component.literal((String)((int)(100.0f * display.getChance2()) + "%")), 74, 27, 0, false);
            guiGraphics.drawString(font, (Component)Component.literal((String)((int)(100.0f * display.getChance3()) + "%")), 74, 45, 0, false);
            poseStack.popPose();
        }), (double)(bounds.x + 3), (double)(bounds.y + 3), (double)0.0));
        return widgets;
    }

    public int getDisplayWidth(LootDisplay display) {
        return 100;
    }
}

