/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.rei;

import com.shynieke.statues.Statues;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.table.StatueTableBlock;
import com.shynieke.statues.compat.rei.category.LootCategory;
import com.shynieke.statues.compat.rei.category.UpgradeCategory;
import com.shynieke.statues.compat.rei.display.LootDisplay;
import com.shynieke.statues.compat.rei.display.UpgradeDisplay;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.items.StatueCoreItem;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeRecipe;
import com.shynieke.statues.recipe.UpgradeType;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@REIPluginClient
public class REIPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<LootDisplay> LOOT = CategoryIdentifier.of((String)"statues", (String)"plugins/loot");
    public static final CategoryIdentifier<UpgradeDisplay> UPGRADE = CategoryIdentifier.of((String)"statues", (String)"plugins/upgrade");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new LootCategory());
        registry.add((DisplayCategory)new UpgradeCategory());
        registry.addWorkstations(LOOT, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)StatueRegistry.STATUE_TABLE.get()))});
        registry.addWorkstations(UPGRADE, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)StatueRegistry.STATUE_TABLE.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        List lootHolders = registry.getRecipeManager().getAllRecipesFor(StatuesRecipes.LOOT_RECIPE.get());
        lootHolders.forEach(holder -> {
            LootRecipe recipe = (LootRecipe)holder.value();
            registry.add((Display)new LootDisplay((Ingredient)recipe.getIngredients().getFirst(), recipe.getResultItem((HolderLookup.Provider)registryAccess), recipe.getChance1(), recipe.getResultItem2((HolderLookup.Provider)registryAccess), recipe.getChance2(), recipe.getResultItem3(registryAccess), recipe.getChance3()));
        });
        List upgradeHolders = registry.getRecipeManager().getAllRecipesFor(StatuesRecipes.UPGRADE_RECIPE.get());
        upgradeHolders.forEach(holder -> {
            ItemStack stack;
            UpgradeRecipe recipe = (UpgradeRecipe)holder.value();
            int tier = recipe.getTier();
            ArrayList<ItemStack> centerList = new ArrayList<ItemStack>();
            for (ItemStack centerStack : recipe.getCenter().getItems()) {
                stack = centerStack.copy();
                if (recipe.getUpgradeType() != UpgradeType.UPGRADE) {
                    this.fillInTag(stack, recipe);
                }
                if (recipe.getUpgradeType() != UpgradeType.UPGRADE) {
                    this.setUpgradeSlots(stack, 1);
                }
                if (recipe.getUpgradeType() == UpgradeType.UNGLOWING) {
                    UpgradeType.GLOWING.apply(stack, -1);
                }
                if (tier > -1) {
                    for (int i = 0; i < tier; ++i) {
                        recipe.getUpgradeType().apply(stack, i);
                    }
                }
                centerList.add(stack);
            }
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)registryAccess).copy();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (result.isEmpty()) {
                for (ItemStack centerStack : centerList) {
                    stack = centerStack.copy();
                    recipe.getUpgradeType().apply(stack, tier);
                    if (recipe.getUpgradeType().isSubsequentUsesSlot()) {
                        this.setUpgradeSlots(stack, 0);
                    }
                    stacks.add(stack);
                }
            } else {
                stacks.add(result);
            }
            registry.add((Display)new UpgradeDisplay(centerList, recipe.getCatalysts(), stacks, recipe.requiresCore(), recipe.getUpgradeType(), tier));
        });
        BuiltinClientPlugin clientPlugin = BuiltinClientPlugin.getInstance();
        List<StatueBlockItem> statues = StatueRegistry.ITEMS.getEntries().stream().filter(registryObject -> {
            AbstractStatueBase statueBase;
            StatueBlockItem statueBlock;
            Block patt1$temp;
            Object patt0$temp = registryObject.get();
            return patt0$temp instanceof StatueBlockItem && (patt1$temp = (statueBlock = (StatueBlockItem)((Object)((Object)patt0$temp))).getBlock()) instanceof AbstractStatueBase && !(statueBase = (AbstractStatueBase)patt1$temp).isHiddenStatue();
        }).map(registryObject -> (StatueBlockItem)((Object)((Object)registryObject.get()))).toList();
        double chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        for (StatueBlockItem statue : statues) {
            if (statue.getEntity() == null) {
                Statues.LOGGER.error("Tried adding info to statue but statue {} has no entity linked", (Object)BuiltInRegistries.ITEM.getKey((Object)statue));
                continue;
            }
            clientPlugin.registerInformation(EntryStacks.of((ItemStack)statue.getDefaultInstance()), (Component)Component.empty(), list -> {
                int chancePercentage = (int)(chance * 100.0);
                if (statue.getEntity() == EntityType.WARDEN || statue.getEntity() == EntityType.ELDER_GUARDIAN) {
                    chancePercentage = 100;
                } else if (statue.getEntity() == EntityType.RAVAGER) {
                    chancePercentage = 25;
                }
                list.add(Component.translatable((String)"statues.gui.jei.statue.info", (Object[])new Object[]{Component.translatable((String)statue.getDescriptionId()).withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD), Component.literal((String)(chancePercentage + "%")).withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.BOLD), Component.translatable((String)statue.getEntity().getDescriptionId()).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)}));
                return list;
            });
        }
        clientPlugin.registerInformation(EntryStacks.of((ItemStack)((StatueCoreItem)((Object)StatueRegistry.STATUE_CORE.get())).getDefaultInstance()), (Component)Component.empty(), list -> {
            list.add(Component.translatable((String)"statues.gui.jei.statue_core.info", (Object[])new Object[]{Component.translatable((String)((StatueCoreItem)((Object)((Object)StatueRegistry.STATUE_CORE.get()))).getDescriptionId()).withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD), Component.translatable((String)StatueRegistry.STATUE_BAT.get().getDescriptionId()).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)}));
            list.add(Component.translatable((String)"statues.gui.jei.statue_core.info2", (Object[])new Object[]{Component.translatable((String)StatueRegistry.STATUE_BAT.get().getDescriptionId()).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)}));
            return list;
        });
        clientPlugin.registerInformation(EntryStacks.of((ItemStack)((StatueTableBlock)((Object)StatueRegistry.STATUE_TABLE.get())).asItem().getDefaultInstance()), (Component)Component.empty(), list -> {
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info"));
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info2"));
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info3"));
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info4"));
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info5"));
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info6"));
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info7"));
            list.add(Component.translatable((String)"statues.gui.jei.statue_table.info8"));
            return list;
        });
    }

    private void fillInTag(ItemStack stack, UpgradeRecipe recipe) {
        int tier = recipe.getTier();
        stack.set(StatueDataComponents.UPGRADED.get(), (Object)true);
        StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS.get(), (Object)StatueStats.empty());
        stats.setLevel(tier == -1 ? 0 : tier + 1);
        stats.setUpgradeSlots(20);
        stack.set(StatueDataComponents.STATS.get(), (Object)stats);
    }

    private void setUpgradeSlots(ItemStack stack, int count) {
        StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS.get(), (Object)StatueStats.empty());
        stats.setUpgradeSlots(count);
        stack.set(StatueDataComponents.STATS.get(), (Object)stats);
    }
}

