/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.jei;

import com.shynieke.statues.Statues;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.table.StatueTableBlock;
import com.shynieke.statues.compat.jei.category.LootCategory;
import com.shynieke.statues.compat.jei.category.UpgradeCategory;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.items.StatueCoreItem;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeRecipe;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = ResourceLocation.fromNamespaceAndPath((String)"statues", (String)"main");
    public static final ResourceLocation LOOT_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"statues", (String)"textures/gui/jei/loot.png");
    public static final RecipeType<LootRecipe> LOOT_TYPE = RecipeType.create((String)"statues", (String)"loot", LootRecipe.class);
    public static final ResourceLocation UPGRADE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"statues", (String)"textures/gui/jei/upgrade.png");
    public static final RecipeType<UpgradeRecipe> UPGRADE_TYPE = RecipeType.create((String)"statues", (String)"upgrade", UpgradeRecipe.class);
    @Nullable
    private IRecipeCategory<LootRecipe> lootCategory;
    @Nullable
    private IRecipeCategory<UpgradeRecipe> upgradeCategory;

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()), new RecipeType[]{LOOT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()), new RecipeType[]{UPGRADE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[2];
        this.lootCategory = new LootCategory(guiHelper);
        iRecipeCategoryArray[0] = this.lootCategory;
        this.upgradeCategory = new UpgradeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.upgradeCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel clientLevel = Objects.requireNonNull(Minecraft.getInstance().level);
        registration.addRecipes(LOOT_TYPE, clientLevel.getRecipeManager().getAllRecipesFor(StatuesRecipes.LOOT_RECIPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(UPGRADE_TYPE, clientLevel.getRecipeManager().getAllRecipesFor(StatuesRecipes.UPGRADE_RECIPE.get()).stream().map(RecipeHolder::value).toList());
        List<StatueBlockItem> statues = StatueRegistry.ITEMS.getEntries().stream().filter(registryObject -> {
            AbstractStatueBase statueBase;
            StatueBlockItem statueBlock;
            Block patt1$temp;
            Object patt0$temp = registryObject.get();
            return patt0$temp instanceof StatueBlockItem && (patt1$temp = (statueBlock = (StatueBlockItem)((Object)((Object)patt0$temp))).getBlock()) instanceof AbstractStatueBase && !(statueBase = (AbstractStatueBase)patt1$temp).isHiddenStatue();
        }).map(registryObject -> (StatueBlockItem)((Object)((Object)registryObject.get()))).toList();
        double chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        for (StatueBlockItem statue : statues) {
            if (statue.getEntity() == null) {
                Statues.LOGGER.error("Tried adding info to statue but statue {} has no entity linked", (Object)BuiltInRegistries.ITEM.getKey((Object)statue));
                continue;
            }
            int chancePercentage = (int)(chance * 100.0);
            if (statue.getEntity() == EntityType.WARDEN || statue.getEntity() == EntityType.ELDER_GUARDIAN) {
                chancePercentage = 100;
            } else if (statue.getEntity() == EntityType.RAVAGER) {
                chancePercentage = 25;
            }
            registration.addItemStackInfo(statue.getDefaultInstance(), new Component[]{Component.translatable((String)"statues.gui.jei.statue.info", (Object[])new Object[]{Component.translatable((String)statue.getDescriptionId()).withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD), Component.literal((String)(chancePercentage + "%")).withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.BOLD), Component.translatable((String)statue.getEntity().getDescriptionId()).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)})});
        }
        registration.addItemStackInfo(((StatueCoreItem)((Object)StatueRegistry.STATUE_CORE.get())).getDefaultInstance(), new Component[]{Component.translatable((String)"statues.gui.jei.statue_core.info", (Object[])new Object[]{Component.translatable((String)((StatueCoreItem)((Object)StatueRegistry.STATUE_CORE.get())).getDescriptionId()).withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD), Component.translatable((String)StatueRegistry.STATUE_BAT.get().getDescriptionId()).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)}), Component.translatable((String)"statues.gui.jei.statue_core.info2", (Object[])new Object[]{Component.translatable((String)StatueRegistry.STATUE_BAT.get().getDescriptionId()).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)})});
        registration.addItemStackInfo(((StatueTableBlock)((Object)StatueRegistry.STATUE_TABLE.get())).asItem().getDefaultInstance(), new Component[]{Component.translatable((String)"statues.gui.jei.statue_table.info"), Component.translatable((String)"statues.gui.jei.statue_table.info2"), Component.translatable((String)"statues.gui.jei.statue_table.info3"), Component.translatable((String)"statues.gui.jei.statue_table.info4"), Component.translatable((String)"statues.gui.jei.statue_table.info5"), Component.translatable((String)"statues.gui.jei.statue_table.info6"), Component.translatable((String)"statues.gui.jei.statue_table.info7"), Component.translatable((String)"statues.gui.jei.statue_table.info8")});
    }
}

