/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.commands;

import com.mojang.brigadier.context.CommandContext;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StatuesDevCommands {
    static int checkLoot(CommandContext<CommandSourceStack> ctx) {
        HashSet beBlocks = new HashSet(StatueBlockEntities.STATUE.get().getValidBlocks());
        beBlocks.addAll(StatueBlockEntities.SHULKER_STATUE.get().getValidBlocks());
        beBlocks.addAll(StatueBlockEntities.TROPICAL_FISH.get().getValidBlocks());
        ArrayList missingBlocks = new ArrayList();
        ((CommandSourceStack)ctx.getSource()).getLevel().getRecipeManager().getAllRecipesFor(StatuesRecipes.LOOT_RECIPE.get()).forEach(recipe -> {
            if (recipe.id().getNamespace().equals("statues")) {
                for (Ingredient ingredient : ((LootRecipe)recipe.value()).getIngredients()) {
                    for (ItemStack stack : ingredient.getItems()) {
                        BlockItem blockItem;
                        Item patt0$temp = stack.getItem();
                        if (!(patt0$temp instanceof BlockItem) || beBlocks.contains((blockItem = (BlockItem)patt0$temp).getBlock())) continue;
                        missingBlocks.add(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()));
                    }
                }
            }
        });
        if (missingBlocks.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"No blocks with loot are missing from the Statue block entity valid blocks"), false);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("The following blocks are missing from the Statue block entity valid blocks: ");
            for (ResourceLocation location : missingBlocks) {
                builder.append(location.toString()).append(", ");
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)builder.toString()));
        }
        return 0;
    }

    static int checkBlockEntity(CommandContext<CommandSourceStack> ctx) {
        HashSet beBlocks = new HashSet(StatueBlockEntities.STATUE.get().getValidBlocks());
        beBlocks.addAll(StatueBlockEntities.SHULKER_STATUE.get().getValidBlocks());
        beBlocks.addAll(StatueBlockEntities.TROPICAL_FISH.get().getValidBlocks());
        ArrayList<ResourceLocation> missingBlocks = new ArrayList<ResourceLocation>();
        for (DeferredHolder holder : StatueRegistry.BLOCKS.getEntries()) {
            AbstractStatueBase base;
            Object object = holder.get();
            if (!(object instanceof AbstractStatueBase) || beBlocks.contains((Object)(base = (AbstractStatueBase)((Object)object)))) continue;
            missingBlocks.add(BuiltInRegistries.BLOCK.getKey((Object)base));
        }
        if (missingBlocks.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"No blocks are missing from the Statue block entity valid blocks"), false);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("The following blocks are missing from the Statue block entity valid blocks: ");
            for (ResourceLocation location : missingBlocks) {
                builder.append(location.toString()).append(", ");
            }
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)builder.toString()));
        }
        return 0;
    }
}

