/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.client.model.StatuePlayerTileModel;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlayerBER
implements BlockEntityRenderer<PlayerBlockEntity> {
    private final StatuePlayerTileModel model;
    private final StatuePlayerTileModel slimModel;
    public boolean isSlim = false;
    public static final ResourceLocation defaultTexture = DefaultPlayerSkin.getDefaultTexture();

    public PlayerBER(BlockEntityRendererProvider.Context context) {
        this.model = new StatuePlayerTileModel(context.bakeLayer(ClientHandler.PLAYER_STATUE), false);
        this.slimModel = new StatuePlayerTileModel(context.bakeLayer(ClientHandler.PLAYER_STATUE_SLIM), true);
    }

    public void render(PlayerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        SkinManager skinmanager;
        BlockState blockstate = blockEntity.getBlockState();
        boolean flag = blockstate.getBlock() instanceof PlayerStatueBlock;
        Direction direction = flag ? (Direction)blockstate.getValue((Property)PlayerStatueBlock.FACING) : Direction.UP;
        ResolvableProfile resolvableProfile = blockEntity.getPlayerProfile();
        if (resolvableProfile != null && this.isSlim != (skinmanager = Minecraft.getInstance().getSkinManager()).getInsecureSkin(resolvableProfile.gameProfile()).model().id().equals("slim")) {
            this.isSlim = !this.isSlim;
        }
        this.render(direction, resolvableProfile, poseStack, bufferSource, combinedLightIn, partialTicks);
    }

    public void render(@Nullable Direction direction, @Nullable ResolvableProfile profile, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, float partialTicks) {
        poseStack.translate(0.5, 0.25, 0.5);
        poseStack.pushPose();
        if (direction != null) {
            switch (direction) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case WEST: {
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                default: {
                    poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                }
            }
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0, -1.25, 0.0);
        boolean isSupporter = false;
        if (profile != null) {
            String s = ChatFormatting.stripFormatting((String)profile.name().orElse("Steve"));
            if ("Dinnerbone".equalsIgnoreCase(s) || "Grumm".equalsIgnoreCase(s)) {
                poseStack.translate(0.0, (double)1.85f, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
            isSupporter = ClientHandler.SUPPORTER.contains(profile.id().orElse(Util.NIL_UUID));
        }
        int light = isSupporter ? 0xF000F0 : combinedLight;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(PlayerBER.getRenderType(profile));
        StatuePlayerTileModel playerModel = this.isSlim ? this.slimModel : this.model;
        playerModel.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public static RenderType getRenderType(@Nullable ResolvableProfile resolvableProfile) {
        if (resolvableProfile == null) {
            return RenderType.entityTranslucent((ResourceLocation)defaultTexture);
        }
        SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
        return RenderType.entityTranslucent((ResourceLocation)skinmanager.getInsecureSkin(resolvableProfile.gameProfile()).texture());
    }
}

