/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.model;

import com.google.common.collect.ImmutableList;
import com.shynieke.statues.entity.PlayerStatue;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PlayerStatueModel
extends PlayerModel<PlayerStatue> {
    public PlayerStatueModel(ModelPart modelPart, boolean slim) {
        super(modelPart, slim);
        this.hat.setRotation(0.0f, -1.75f, 0.0f);
        this.rightSleeve.setRotation(-5.0f, 2.0f, 0.0f);
    }

    public static MeshDefinition createStatueMesh(CubeDeformation cubeDeformation, boolean slim) {
        MeshDefinition meshdefinition = PlayerModel.createMesh((CubeDeformation)cubeDeformation, (boolean)slim);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation.extend(2.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        if (slim) {
            partdefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        } else {
            partdefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        }
        return meshdefinition;
    }

    public void setupAnim(PlayerStatue entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = (float)Math.PI / 180 * entityIn.getHeadRotation().getX();
        this.head.yRot = (float)Math.PI / 180 * entityIn.getHeadRotation().getY();
        this.head.zRot = (float)Math.PI / 180 * entityIn.getHeadRotation().getZ();
        this.body.xRot = (float)Math.PI / 180 * entityIn.getBodyRotation().getX();
        this.body.yRot = (float)Math.PI / 180 * entityIn.getBodyRotation().getY();
        this.body.zRot = (float)Math.PI / 180 * entityIn.getBodyRotation().getZ();
        this.leftArm.xRot = (float)Math.PI / 180 * entityIn.getLeftArmRotation().getX();
        this.leftArm.yRot = (float)Math.PI / 180 * entityIn.getLeftArmRotation().getY();
        this.leftArm.zRot = (float)Math.PI / 180 * entityIn.getLeftArmRotation().getZ();
        this.rightArm.xRot = (float)Math.PI / 180 * entityIn.getRightArmRotation().getX();
        this.rightArm.yRot = (float)Math.PI / 180 * entityIn.getRightArmRotation().getY();
        this.rightArm.zRot = (float)Math.PI / 180 * entityIn.getRightArmRotation().getZ();
        this.leftLeg.xRot = (float)Math.PI / 180 * entityIn.getLeftLegRotation().getX();
        this.leftLeg.yRot = (float)Math.PI / 180 * entityIn.getLeftLegRotation().getY();
        this.leftLeg.zRot = (float)Math.PI / 180 * entityIn.getLeftLegRotation().getZ();
        this.rightLeg.xRot = (float)Math.PI / 180 * entityIn.getRightLegRotation().getX();
        this.rightLeg.yRot = (float)Math.PI / 180 * entityIn.getRightLegRotation().getY();
        this.rightLeg.zRot = (float)Math.PI / 180 * entityIn.getRightLegRotation().getZ();
        this.hat.copyFrom(this.head);
        this.jacket.copyFrom(this.body);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.hat);
    }
}

