/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.shynieke.statues.blockentities.StatueTableBlockEntity;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class StatueTableBER
implements BlockEntityRenderer<StatueTableBlockEntity> {
    public StatueTableBER(BlockEntityRendererProvider.Context context) {
    }

    public void render(StatueTableBlockEntity tableBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (tableBlockEntity.getHandler() != null) {
            ItemStackHandler handler = tableBlockEntity.getHandler();
            BlockState state = tableBlockEntity.getBlockState();
            Direction direction = (Direction)state.getValue((Property)AbstractBaseBlock.FACING);
            poseStack.pushPose();
            switch (direction) {
                default: {
                    break;
                }
                case EAST: {
                    poseStack.translate(1.0f, 0.0f, 0.0f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.translate(1.0f, 0.0f, 1.0f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case WEST: {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                }
            }
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            ItemStack statueStack = handler.getStackInSlot(0);
            if (!statueStack.isEmpty()) {
                float f = (float)tableBlockEntity.time + partialTicks;
                poseStack.pushPose();
                poseStack.translate(0.5, 0.5625, 0.5);
                poseStack.translate(0.0, (double)(0.1f + Mth.sin((float)(f * 0.2f)) * 0.01f), 0.0);
                Minecraft.getInstance().getItemRenderer().renderStatic(statueStack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferSource, (Level)level, 0);
                poseStack.popPose();
            }
            ItemStack coreStack = handler.getStackInSlot(1);
            if (!statueStack.isEmpty()) {
                poseStack.pushPose();
                poseStack.translate(0.546875, 0.15625, 0.8125);
                poseStack.scale(0.3125f, 0.3125f, 0.3125f);
                Minecraft.getInstance().getItemRenderer().renderStatic(coreStack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferSource, (Level)level, 0);
                poseStack.popPose();
            }
            for (int i = 2; i < 6; ++i) {
                ItemStack catalystSTack = handler.getStackInSlot(i);
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                float zOffset = 0.0f;
                switch (i) {
                    default: {
                        xOffset = 0.125f;
                        yOffset = 0.0f;
                        zOffset = 0.125f;
                        break;
                    }
                    case 3: {
                        xOffset = -0.125f;
                        yOffset = 0.0f;
                        zOffset = 0.125f;
                        break;
                    }
                    case 4: {
                        xOffset = 0.125f;
                        yOffset = 0.0f;
                        zOffset = -0.125f;
                        break;
                    }
                    case 5: {
                        xOffset = -0.125f;
                        yOffset = 0.0f;
                        zOffset = -0.125f;
                    }
                }
                if (statueStack.isEmpty()) continue;
                poseStack.pushPose();
                poseStack.translate(0.5 + (double)xOffset, 0.5625 + (double)yOffset, 0.5 + (double)zOffset);
                poseStack.scale(0.125f, 0.125f, 0.125f);
                Minecraft.getInstance().getItemRenderer().renderStatic(catalystSTack, ItemDisplayContext.GUI, combinedLightIn, combinedOverlayIn, poseStack, bufferSource, (Level)level, 0);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }
}

