/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.table;

import com.shynieke.statues.blockentities.StatueTableBlockEntity;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.registry.StatueBlockEntities;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class StatueTableBlock
extends AbstractBaseBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.box((double)2.0, (double)2.0, (double)2.0, (double)4.0, (double)5.0, (double)4.0), Block.box((double)2.0, (double)2.0, (double)12.0, (double)4.0, (double)5.0, (double)14.0), Block.box((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)5.0, (double)14.0), Block.box((double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)5.0, (double)4.0), Block.box((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.box((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), Block.box((double)3.0, (double)7.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public StatueTableBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player playerIn, BlockHitResult hit) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof StatueTableBlockEntity) {
            StatueTableBlockEntity statueTableBlockEntity = (StatueTableBlockEntity)blockentity;
            if (!level.isClientSide) {
                statueTableBlockEntity.hasValidRecipe();
                playerIn.openMenu((MenuProvider)((StatueTableBlockEntity)blockentity), pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            StatueTableBlockEntity tableBlockEntity;
            ItemStackHandler handler;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof StatueTableBlockEntity && (handler = (tableBlockEntity = (StatueTableBlockEntity)blockentity).getHandler()) != null) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)handler.getStackInSlot(i));
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new StatueTableBlockEntity(pos, blockState);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return StatueTableBlock.createTableTicker(level, blockEntityType, StatueBlockEntities.STATUE_TABLE.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTableTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends StatueTableBlockEntity> blockEntityType1) {
        return level.isClientSide ? StatueTableBlock.createTickerHelper(blockEntityType, blockEntityType1, StatueTableBlockEntity::renderTick) : StatueTableBlock.createTickerHelper(blockEntityType, blockEntityType1, StatueTableBlockEntity::serverTick);
    }
}

