/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.google.common.collect.Maps;
import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SheepStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.box((double)4.0, (double)0.0, (double)3.5, (double)12.0, (double)8.5, (double)12.5);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.box((double)3.5, (double)0.0, (double)4.0, (double)12.5, (double)8.5, (double)12.0);
    private static final Map<DyeColor, SheepStatueBlock> COLOR_DYE_STATUE_MAP = Maps.newEnumMap(DyeColor.class);
    private final DyeColor COLOR;

    public SheepStatueBlock(BlockBehaviour.Properties builder, DyeColor color) {
        super(builder.sound(SoundType.STONE));
        this.COLOR = color;
        COLOR_DYE_STATUE_MAP.put(color, this);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Block block;
        DyeItem dyeItem;
        Item item = stack.getItem();
        if (item instanceof DyeItem && this.COLOR != (dyeItem = (DyeItem)item).getDyeColor() && (block = (Block)COLOR_DYE_STATUE_MAP.get(dyeItem.getDyeColor())) != null) {
            CompoundTag blockData = new CompoundTag();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof StatueBlockEntity) {
                StatueBlockEntity blockEntity2 = (StatueBlockEntity)blockEntity;
                blockData = blockEntity2.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
            BlockState copiedState = (BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)INTERACTIVE, (Comparable)((Boolean)state.getValue((Property)INTERACTIVE)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            level.setBlock(pos, copiedState, 3);
            if (copiedState.hasBlockEntity() && !blockData.isEmpty()) {
                StatueBlockEntity blockEntity3 = new StatueBlockEntity(pos, copiedState);
                blockEntity3.loadWithComponents(blockData, (HolderLookup.Provider)level.registryAccess());
                level.setBlockEntity((BlockEntity)blockEntity3);
            }
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.SHEEP;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.SHEEP_AMBIENT;
    }

    public DyeColor getColor() {
        return this.COLOR;
    }

    public static SheepStatueBlock getStatue(DyeColor color) {
        return COLOR_DYE_STATUE_MAP.get(color);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction.getAxis() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }
}

