/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractStatueBase;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RabbitStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.5, (double)10.0);

    public RabbitStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.sound(SoundType.STONE));
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.RABBIT;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.RABBIT_AMBIENT;
    }

    @Override
    public LivingEntity adjustSpawnedEntity(LivingEntity livingEntity) {
        if (livingEntity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)livingEntity;
            if (rabbit.level().random.nextDouble() < 0.2) {
                rabbit.setVariant(Rabbit.Variant.EVIL);
                return rabbit;
            }
        }
        return livingEntity;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

